/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.edgeInteraction;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.kinetics.crafter.CrafterHelper;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionHandler;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EdgeInteractionRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        LocalPlayer player = mc.f_91074_;
        ItemStack heldItem = player.m_21205_();
        if (player.m_6144_()) {
            return;
        }
        EdgeInteractionBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)world, pos, EdgeInteractionBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (behaviour.requiredItem.orElse(heldItem.m_41720_()) != heldItem.m_41720_()) {
            return;
        }
        Direction face = result.m_82434_();
        List<Direction> connectiveSides = EdgeInteractionHandler.getConnectiveSides((Level)world, pos, face, behaviour);
        if (connectiveSides.isEmpty()) {
            return;
        }
        Direction closestEdge = connectiveSides.get(0);
        double bestDistance = Double.MAX_VALUE;
        Vec3 center = VecHelper.getCenterOf((Vec3i)pos);
        for (Direction direction : connectiveSides) {
            double distance = Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82546_(target.m_82450_().m_82546_(center)).m_82553_();
            if (distance > bestDistance) continue;
            bestDistance = distance;
            closestEdge = direction;
        }
        AABB bb = EdgeInteractionHandler.getBB(pos, closestEdge);
        boolean hit = bb.m_82390_(target.m_82450_());
        Vec3 offset = Vec3.m_82528_((Vec3i)closestEdge.m_122436_()).m_82490_(0.5).m_82549_(Vec3.m_82528_((Vec3i)face.m_122436_()).m_82490_(0.469)).m_82549_(VecHelper.CENTER_OF_ORIGIN);
        ValueBox box = new ValueBox(CommonComponents.f_237098_, bb, pos).passive(!hit).transform(new EdgeValueBoxTransform(offset)).wideOutline();
        Outliner.getInstance().showOutline((Object)"edge", (Outline)box).highlightFace(face);
        if (!hit) {
            return;
        }
        ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
        tip.add(CreateLang.translateDirect("logistics.crafter.connected", new Object[0]));
        tip.add(CreateLang.translateDirect(CrafterHelper.areCraftersConnected((BlockAndTintGetter)world, pos, pos.m_121945_(closestEdge)) ? "logistics.crafter.click_to_separate" : "logistics.crafter.click_to_merge", new Object[0]));
        CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip(tip);
    }

    static class EdgeValueBoxTransform
    extends ValueBoxTransform.Sided {
        private Vec3 add;

        public EdgeValueBoxTransform(Vec3 add) {
            this.add = add;
        }

        @Override
        protected Vec3 getSouthLocation() {
            return Vec3.f_82478_;
        }

        @Override
        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            return this.add;
        }

        @Override
        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
        }
    }
}

