/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items.vehicles;

import earth.terrarium.adastra.common.blocks.LaunchPadBlock;
import earth.terrarium.adastra.common.blocks.properties.LaunchPadPartProperty;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.items.vehicles.VehicleItem;
import earth.terrarium.adastra.common.tags.ModBlockTags;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RocketItem
extends VehicleItem {
    public RocketItem(Supplier<EntityType<?>> type, Item.Properties properties) {
        super(type, properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        BlockState state = level.m_8055_(pos);
        if (!state.m_204336_(ModBlockTags.LAUNCH_PADS)) {
            return InteractionResult.PASS;
        }
        if (state.m_61138_(LaunchPadBlock.PART) && state.m_61143_(LaunchPadBlock.PART) != LaunchPadPartProperty.CENTER) {
            return InteractionResult.PASS;
        }
        level.m_5594_(null, pos, SoundEvents.f_12200_, SoundSource.BLOCKS, 1.0f, 1.0f);
        Entity vehicle = this.type().m_20615_(level);
        if (vehicle == null) {
            return InteractionResult.PASS;
        }
        vehicle.m_6034_((double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + 0.125f), (double)pos.m_123343_() + 0.5);
        vehicle.m_146922_(context.m_8125_().m_122424_().m_122435_());
        level.m_7967_(vehicle);
        if (vehicle instanceof Rocket) {
            Rocket rocket = (Rocket)vehicle;
            ItemStackHolder holder = new ItemStackHolder(stack);
            FluidContainer container = this.getFluidContainer(stack).container();
            ItemFluidContainer fromContainer = FluidContainer.of((ItemStackHolder)holder);
            if (fromContainer == null) {
                return InteractionResult.PASS;
            }
            FluidApi.moveFluid((FluidContainer)fromContainer, (FluidContainer)rocket.fluidContainer(), (FluidHolder)container.getFirstFluid(), (boolean)false);
        }
        stack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.ROCKET_INFO);
    }
}

