/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.mob.lunarians;

import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import org.jetbrains.annotations.Nullable;

public class LunarianWanderingTraderSpawner
implements CustomSpawner {
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int DEFAULT_SPAWN_TIMER = 1200;
    private final Random random = new Random();
    private final ServerLevelData properties;
    private int spawnTimer;
    private int spawnDelay;
    private int spawnChance;

    public LunarianWanderingTraderSpawner(ServerLevelData properties) {
        this.properties = properties;
        this.spawnTimer = 1200;
        this.spawnDelay = properties.m_6530_();
        this.spawnChance = properties.m_6528_();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 24000;
            properties.m_6391_(this.spawnDelay);
            this.spawnChance = 25;
            properties.m_6387_(this.spawnChance);
        }
    }

    public int m_7995_(ServerLevel level, boolean spawnMonsters, boolean spawnAnimals) {
        if (!level.m_46469_().m_46207_(GameRules.f_46125_)) {
            return 0;
        }
        if (--this.spawnTimer > 0) {
            return 0;
        }
        this.spawnTimer = 1200;
        this.spawnDelay -= 1200;
        this.properties.m_6391_(this.spawnDelay);
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = 24000;
        if (!level.m_46469_().m_46207_(GameRules.f_46134_)) {
            return 0;
        }
        int i = this.spawnChance;
        this.spawnChance = Mth.m_14045_((int)(this.spawnChance + 25), (int)25, (int)75);
        this.properties.m_6387_(this.spawnChance);
        if (this.random.nextInt(100) > i) {
            return 0;
        }
        if (this.trySpawn(level)) {
            this.spawnChance = 25;
            return 1;
        }
        return 0;
    }

    private boolean trySpawn(ServerLevel level) {
        ServerPlayer playerEntity = level.m_8890_();
        if (playerEntity == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        if (!PlanetApi.API.isPlanet((ResourceKey<Level>)level.m_46472_())) {
            return false;
        }
        if (Level.f_46428_.equals(level.m_46472_())) {
            return false;
        }
        BlockPos blockPos = playerEntity.m_20183_();
        PoiManager pointOfInterestStorage = level.m_8904_();
        Optional optional = pointOfInterestStorage.m_27186_(holder -> holder.m_203565_(PoiTypes.f_218061_), pos -> true, blockPos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockPos2 = optional.orElse(blockPos);
        BlockPos blockPos3 = this.getNearbySpawnPos((LevelReader)level, blockPos2, 48);
        if (blockPos3 != null && this.doesNotSuffocateAt((BlockGetter)level, blockPos3)) {
            if (level.m_204166_(blockPos3).m_203656_(BiomeTags.f_215807_)) {
                return false;
            }
            WanderingTrader wanderingTraderEntity = (WanderingTrader)((EntityType)ModEntityTypes.LUNARIAN_WANDERING_TRADER.get()).m_262496_(level, blockPos3, MobSpawnType.EVENT);
            if (wanderingTraderEntity != null) {
                this.properties.m_8115_(wanderingTraderEntity.m_20148_());
                wanderingTraderEntity.m_35891_(48000);
                wanderingTraderEntity.m_35883_(blockPos2);
                wanderingTraderEntity.m_21446_(blockPos2, 16);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private BlockPos getNearbySpawnPos(LevelReader level, BlockPos pos, int range) {
        BlockPos blockPos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int j = pos.m_123341_() + this.random.nextInt(range * 2) - range;
            BlockPos blockPos2 = BlockPos.m_274561_((double)j, (double)level.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = pos.m_123343_() + this.random.nextInt(range * 2) - range), (double)k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)blockPos2, (EntityType)((EntityType)ModEntityTypes.LUNARIAN_WANDERING_TRADER.get()))) continue;
            blockPos = blockPos2;
            break;
        }
        return blockPos;
    }

    private boolean doesNotSuffocateAt(BlockGetter level, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(1, 2, 1))) {
            if (level.m_8055_(blockPos).m_60812_(level, blockPos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

