/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.renderers.world;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import org.joml.Matrix4f;

public class OverlayRenderer {
    private final Map<BlockPos, Set<BlockPos>> positions = new HashMap<BlockPos, Set<BlockPos>>();
    private final int color;
    private final BooleanSupplier config;
    private final Supplier<Block> block;

    public OverlayRenderer(int color, BooleanSupplier config, Supplier<Block> block) {
        this.color = color;
        this.config = config;
        this.block = block;
    }

    public void addPositions(BlockPos pos, Set<BlockPos> positions) {
        this.positions.put(pos, positions);
    }

    public void removePositions(BlockPos pos) {
        this.positions.remove(pos);
    }

    public void clearPositions() {
        this.positions.clear();
    }

    public boolean canAdd(BlockPos pos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return player.m_20183_().m_123314_((Vec3i)pos, 128.0);
    }

    public void render(PoseStack poseStack, Camera camera) {
        if (!this.config.getAsBoolean()) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (level.m_46467_() % 40L == 0L) {
            this.positions.keySet().removeIf(pos -> !level.m_46749_(pos) || !this.canAdd((BlockPos)pos) || !level.m_8055_(pos).m_60713_(this.block.get()));
        }
        poseStack.m_85836_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_280070_());
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        poseStack.m_85837_(-camera.m_90583_().m_7096_(), -camera.m_90583_().m_7098_(), -camera.m_90583_().m_7094_());
        this.positions.values().forEach(positions -> positions.forEach(pos -> this.renderCube(poseStack, consumer, (BlockPos)pos, (Set<BlockPos>)positions)));
        bufferSource.m_109911_();
        RenderSystem.enableCull();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private void renderCube(PoseStack poseStack, VertexConsumer consumer, BlockPos pos, Set<BlockPos> others) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int minX = pos.m_123341_();
        int minY = pos.m_123342_();
        int minZ = pos.m_123343_();
        int maxX = minX + 1;
        int maxY = minY + 1;
        int maxZ = minZ + 1;
        if (!others.contains(pos.m_7495_())) {
            consumer.m_252986_(matrix, (float)minX, (float)minY, (float)minZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)minZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)maxZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)minX, (float)minY, (float)maxZ).m_193479_(this.color).m_5752_();
        }
        if (!others.contains(pos.m_7494_())) {
            consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)maxZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)maxZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)minZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)minZ).m_193479_(this.color).m_5752_();
        }
        if (!others.contains(pos.m_122012_())) {
            consumer.m_252986_(matrix, (float)minX, (float)minY, (float)minZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)minZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)minZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)minZ).m_193479_(this.color).m_5752_();
        }
        if (!others.contains(pos.m_122019_())) {
            consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)maxZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)maxZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)maxZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)minX, (float)minY, (float)maxZ).m_193479_(this.color).m_5752_();
        }
        if (!others.contains(pos.m_122029_())) {
            consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)minZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)minZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)maxY, (float)maxZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)maxX, (float)minY, (float)maxZ).m_193479_(this.color).m_5752_();
        }
        if (!others.contains(pos.m_122024_())) {
            consumer.m_252986_(matrix, (float)minX, (float)minY, (float)maxZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)maxZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)minX, (float)maxY, (float)minZ).m_193479_(this.color).m_5752_();
            consumer.m_252986_(matrix, (float)minX, (float)minY, (float)minZ).m_193479_(this.color).m_5752_();
        }
    }
}

