/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

public class MobBucketItem
extends BucketItem {
    private final Supplier<? extends EntityType<?>> entityTypeSupplier;
    private final Supplier<? extends SoundEvent> emptySoundSupplier;

    @Deprecated
    public MobBucketItem(EntityType<?> p_151137_, Fluid p_151138_, SoundEvent p_151139_, Item.Properties p_151140_) {
        this(() -> p_151137_, () -> p_151138_, () -> p_151139_, p_151140_);
    }

    public MobBucketItem(Supplier<? extends EntityType<?>> entitySupplier, Supplier<? extends Fluid> fluidSupplier, Supplier<? extends SoundEvent> soundSupplier, Item.Properties properties) {
        super(fluidSupplier, properties);
        this.emptySoundSupplier = soundSupplier;
        this.entityTypeSupplier = entitySupplier;
    }

    @Override
    public void m_142131_(@Nullable Player p_151146_, Level p_151147_, ItemStack p_151148_, BlockPos p_151149_) {
        if (p_151147_ instanceof ServerLevel) {
            this.m_151141_((ServerLevel)p_151147_, p_151148_, p_151149_);
            p_151147_.m_142346_(p_151146_, GameEvent.f_157810_, p_151149_);
        }
    }

    @Override
    protected void m_7718_(@Nullable Player p_151151_, LevelAccessor p_151152_, BlockPos p_151153_) {
        p_151152_.m_5594_(p_151151_, p_151153_, this.getEmptySound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void m_151141_(ServerLevel p_151142_, ItemStack p_151143_, BlockPos p_151144_) {
        Object entity = this.getFishType().m_20592_(p_151142_, p_151143_, null, p_151144_, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucketable.m_142278_(p_151143_.m_41784_());
            bucketable.m_27497_(true);
        }
    }

    @Override
    public void m_7373_(ItemStack p_151155_, @Nullable Level p_151156_, List<Component> p_151157_, TooltipFlag p_151158_) {
        CompoundTag compoundtag;
        if (this.getFishType() == EntityType.f_20489_ && (compoundtag = p_151155_.m_41783_()) != null && compoundtag.m_128425_("BucketVariantTag", 3)) {
            int i = compoundtag.m_128451_("BucketVariantTag");
            ChatFormatting[] achatformatting = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            String s = "color.minecraft." + String.valueOf((Object)TropicalFish.m_30050_((int)i));
            String s1 = "color.minecraft." + String.valueOf((Object)TropicalFish.m_30052_((int)i));
            for (int j = 0; j < TropicalFish.f_30007_.size(); ++j) {
                if (i != ((TropicalFish.Variant)TropicalFish.f_30007_.get(j)).m_262472_()) continue;
                p_151157_.add((Component)Component.m_237115_((String)TropicalFish.m_30030_((int)j)).m_130944_(achatformatting));
                return;
            }
            p_151157_.add((Component)TropicalFish.m_262390_((int)i).m_262502_().m_6879_().m_130944_(achatformatting));
            MutableComponent mutablecomponent = Component.m_237115_((String)s);
            if (!s.equals(s1)) {
                mutablecomponent.m_130946_(", ").m_7220_((Component)Component.m_237115_((String)s1));
            }
            mutablecomponent.m_130944_(achatformatting);
            p_151157_.add((Component)mutablecomponent);
        }
    }

    protected EntityType<?> getFishType() {
        return this.entityTypeSupplier.get();
    }

    protected SoundEvent getEmptySound() {
        return this.emptySoundSupplier.get();
    }
}

