/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.hopper;

import com.abdelaziz.canary.api.inventory.CanaryInventory;
import com.abdelaziz.canary.common.block.entity.inventory_change_tracking.InventoryChangeEmitter;
import com.abdelaziz.canary.common.block.entity.inventory_change_tracking.InventoryChangeListener;
import com.abdelaziz.canary.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import com.abdelaziz.canary.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import com.abdelaziz.canary.common.hopper.CanaryDoubleStackList;
import com.abdelaziz.canary.common.hopper.CanaryStackList;
import com.abdelaziz.canary.common.hopper.InventoryHelper;
import com.abdelaziz.canary.mixin.block.hopper.CompoundContainerAccessor;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class CanaryDoubleInventory
extends CompoundContainer
implements CanaryInventory,
InventoryChangeTracker,
InventoryChangeEmitter,
InventoryChangeListener,
ComparatorTracker {
    private Container container1;
    private Container container2;
    private CanaryStackList doubleStackList;
    ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = null;
    ReferenceOpenHashSet<InventoryChangeListener> inventoryHandlingTypeListeners = null;

    private CanaryDoubleInventory(CanaryInventory container1, CanaryInventory container2) {
        super((Container)container1, (Container)container2);
        this.container1 = container1;
        this.container2 = container2;
    }

    public static CanaryDoubleInventory getCanaryInventory(CompoundContainer doubleInventory) {
        Container vanillaSecond;
        Container vanillaFirst = ((CompoundContainerAccessor)doubleInventory).getFirst();
        if (vanillaFirst != (vanillaSecond = ((CompoundContainerAccessor)doubleInventory).getSecond()) && vanillaFirst instanceof CanaryInventory) {
            CanaryInventory container1 = (CanaryInventory)vanillaFirst;
            if (vanillaSecond instanceof CanaryInventory) {
                CanaryInventory container2 = (CanaryInventory)vanillaSecond;
                CanaryDoubleInventory newDoubleInventory = new CanaryDoubleInventory(container1, container2);
                CanaryDoubleStackList doubleStackList = CanaryDoubleStackList.getOrCreate(newDoubleInventory, InventoryHelper.getCanaryStackList(container1), InventoryHelper.getCanaryStackList(container2), newDoubleInventory.m_6893_());
                newDoubleInventory.doubleStackList = doubleStackList;
                return doubleStackList.doubleInventory;
            }
        }
        return null;
    }

    @Override
    public void emitContentModified() {
        ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null) {
            for (InventoryChangeListener inventoryChangeListener : inventoryChangeListeners) {
                inventoryChangeListener.handleInventoryContentModified(this);
            }
            inventoryChangeListeners.clear();
        }
    }

    @Override
    public void emitStackListReplaced() {
        ReferenceOpenHashSet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        if (listeners != null && !listeners.isEmpty()) {
            listeners.forEach(inventoryChangeListener -> inventoryChangeListener.handleStackListReplaced(this));
        }
    }

    @Override
    public void emitRemoved() {
        ReferenceOpenHashSet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        if (listeners != null && !listeners.isEmpty()) {
            listeners.forEach(listener -> listener.handleInventoryRemoved(this));
        }
        this.invalidateChangeListening();
    }

    private void invalidateChangeListening() {
        CanaryStackList canaryStackList;
        if (this.inventoryChangeListeners != null) {
            this.inventoryChangeListeners.clear();
        }
        if ((canaryStackList = InventoryHelper.getCanaryStackListOrNull(this)) != null) {
            canaryStackList.removeInventoryModificationCallback(this);
        }
    }

    @Override
    public void emitFirstComparatorAdded() {
        ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null && !inventoryChangeListeners.isEmpty()) {
            inventoryChangeListeners.removeIf(inventoryChangeListener -> inventoryChangeListener.handleComparatorAdded(this));
        }
    }

    @Override
    public void forwardContentChangeOnce(InventoryChangeListener inventoryChangeListener, CanaryStackList stackList, InventoryChangeTracker thisTracker) {
        if (this.inventoryChangeListeners == null) {
            this.inventoryChangeListeners = new ReferenceOpenHashSet(1);
        }
        stackList.setInventoryModificationCallback(thisTracker);
        this.inventoryChangeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void forwardMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners == null) {
            this.inventoryHandlingTypeListeners = new ReferenceOpenHashSet(1);
            ((InventoryChangeTracker)this.container1).listenForMajorInventoryChanges(this);
            ((InventoryChangeTracker)this.container2).listenForMajorInventoryChanges(this);
        }
        this.inventoryHandlingTypeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void stopForwardingMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners != null) {
            this.inventoryHandlingTypeListeners.remove((Object)inventoryChangeListener);
            if (this.inventoryHandlingTypeListeners.isEmpty()) {
                ((InventoryChangeTracker)this.container1).stopListenForMajorInventoryChanges(this);
                ((InventoryChangeTracker)this.container2).stopListenForMajorInventoryChanges(this);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getInventoryCanary() {
        return this.doubleStackList;
    }

    @Override
    public void setInventoryCanary(NonNullList<ItemStack> inventory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleStackListReplaced(Container inventory) {
        this.emitRemoved();
    }

    @Override
    public void handleInventoryContentModified(Container inventory) {
        this.emitContentModified();
    }

    @Override
    public void handleInventoryRemoved(Container inventory) {
        this.emitRemoved();
    }

    @Override
    public boolean handleComparatorAdded(Container inventory) {
        this.emitFirstComparatorAdded();
        return this.inventoryChangeListeners.isEmpty();
    }

    @Override
    public void onComparatorAdded(Direction direction, int offset) {
        throw new UnsupportedOperationException("Call onComparatorAdded(Direction direction, int offset) on the inventory half only!");
    }

    @Override
    public boolean hasAnyComparatorNearby() {
        return ((ComparatorTracker)this.container1).hasAnyComparatorNearby() || ((ComparatorTracker)this.container2).hasAnyComparatorNearby();
    }
}

