/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.forsteri.ratatouille.content.compost_tower.CompostFluidTank;
import org.forsteri.ratatouille.entry.CRFluids;
import org.forsteri.ratatouille.entry.CRItems;
import org.jetbrains.annotations.NotNull;

public class CompostItemHandler
implements IItemHandlerModifiable {
    protected CompostFluidTank tank;
    private static final int ITEM_FLUID_RATIO = 80;
    private static final BiMap<Fluid, Item> ITEM_FLUID_MAP = HashBiMap.create();

    CompostItemHandler(CompostFluidTank tank) {
        this.tank = tank;
    }

    private ItemStack fluidToItem(FluidStack fluidStack) {
        int amount = fluidStack.getAmount() / 80;
        Fluid fluid = fluidStack.getFluid();
        if (amount == 0 || !ITEM_FLUID_MAP.containsKey((Object)fluid)) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)ITEM_FLUID_MAP.get((Object)fluid), amount);
    }

    private FluidStack itemToFluid(ItemStack itemStack) {
        int amount = itemStack.m_41613_() * 80;
        Item item = itemStack.m_41720_();
        if (amount == 0 || !ITEM_FLUID_MAP.inverse().containsKey((Object)item)) {
            return FluidStack.EMPTY;
        }
        return new FluidStack((Fluid)ITEM_FLUID_MAP.inverse().get((Object)item), amount);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.tank.fill(this.itemToFluid(stack), IFluidHandler.FluidAction.EXECUTE);
    }

    public int getSlots() {
        return this.tank.getTanks();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.fluidToItem(this.tank.getFluidInTank(slot));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        int remaining = stack.m_41613_() - this.tank.fill(this.itemToFluid(stack), action);
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        FluidStack targetFluid = this.tank.getFluidInTank(slot);
        FluidStack extracted = this.tank.drain(new FluidStack(targetFluid, amount), action);
        return this.fluidToItem(extracted);
    }

    public int getSlotLimit(int slot) {
        return this.tank.getTankCapacity(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        FluidStack fluid = this.itemToFluid(stack);
        if (fluid.isEmpty()) {
            return false;
        }
        return this.tank.getFluidInTank(slot).isFluidEqual(fluid);
    }

    public boolean consume(ItemStack item, boolean simulate) {
        FluidStack fluid = this.itemToFluid(item);
        if (fluid.isEmpty()) {
            return false;
        }
        if (this.tank.drain(fluid, IFluidHandler.FluidAction.SIMULATE).getAmount() >= fluid.getAmount()) {
            this.tank.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    static {
        ITEM_FLUID_MAP.put((Object)((Fluid)CRFluids.COMPOST_FLUID.get()), (Object)((Item)CRItems.COMPOST_MASS.get()));
    }
}

