/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.slf4j.Logger;

public class ClientRecipeBook
extends RecipeBook {
    private static final Logger f_90618_ = LogUtils.getLogger();
    private Map<RecipeBookCategories, List<RecipeCollection>> f_90619_ = ImmutableMap.of();
    private List<RecipeCollection> f_90620_ = ImmutableList.of();

    public void m_266394_(Iterable<Recipe<?>> p_266814_, RegistryAccess p_266878_) {
        Map<RecipeBookCategories, List<List<Recipe<?>>>> $$2 = ClientRecipeBook.m_90642_(p_266814_);
        HashMap $$3 = Maps.newHashMap();
        ImmutableList.Builder $$4 = ImmutableList.builder();
        $$2.forEach((p_266602_, p_266603_) -> $$3.put(p_266602_, (List)p_266603_.stream().map(p_266605_ -> new RecipeCollection(p_266878_, (List<Recipe<?>>)p_266605_)).peek(arg_0 -> ((ImmutableList.Builder)$$4).add(arg_0)).collect(ImmutableList.toImmutableList())));
        RecipeBookCategories.f_92260_.forEach((p_90637_, p_90638_) -> $$3.put(p_90637_, (List)p_90638_.stream().flatMap(p_167706_ -> ((List)$$3.getOrDefault(p_167706_, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList())));
        this.f_90619_ = ImmutableMap.copyOf((Map)$$3);
        this.f_90620_ = $$4.build();
    }

    private static Map<RecipeBookCategories, List<List<Recipe<?>>>> m_90642_(Iterable<Recipe<?>> p_90643_) {
        HashMap $$1 = Maps.newHashMap();
        HashBasedTable $$2 = HashBasedTable.create();
        for (Recipe<?> $$3 : p_90643_) {
            if ($$3.m_5598_() || $$3.m_142505_()) continue;
            RecipeBookCategories $$4 = ClientRecipeBook.m_90646_($$3);
            String $$5 = $$3.m_6076_();
            if ($$5.isEmpty()) {
                $$1.computeIfAbsent($$4, p_90645_ -> Lists.newArrayList()).add(ImmutableList.of($$3));
                continue;
            }
            List $$6 = (List)$$2.get((Object)$$4, (Object)$$5);
            if ($$6 == null) {
                $$6 = Lists.newArrayList();
                $$2.put((Object)$$4, (Object)$$5, (Object)$$6);
                $$1.computeIfAbsent($$4, p_90641_ -> Lists.newArrayList()).add($$6);
            }
            $$6.add($$3);
        }
        return $$1;
    }

    private static RecipeBookCategories m_90646_(Recipe<?> p_90647_) {
        if (p_90647_ instanceof CraftingRecipe) {
            CraftingRecipe $$1 = (CraftingRecipe)p_90647_;
            return switch ($$1.m_245232_()) {
                default -> throw new IncompatibleClassChangeError();
                case CraftingBookCategory.BUILDING -> RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
                case CraftingBookCategory.EQUIPMENT -> RecipeBookCategories.CRAFTING_EQUIPMENT;
                case CraftingBookCategory.REDSTONE -> RecipeBookCategories.CRAFTING_REDSTONE;
                case CraftingBookCategory.MISC -> RecipeBookCategories.CRAFTING_MISC;
            };
        }
        RecipeType<?> $$2 = p_90647_.m_6671_();
        if (p_90647_ instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe $$3 = (AbstractCookingRecipe)p_90647_;
            CookingBookCategory $$4 = $$3.m_245534_();
            if ($$2 == RecipeType.f_44108_) {
                return switch ($$4) {
                    default -> throw new IncompatibleClassChangeError();
                    case CookingBookCategory.BLOCKS -> RecipeBookCategories.FURNACE_BLOCKS;
                    case CookingBookCategory.FOOD -> RecipeBookCategories.FURNACE_FOOD;
                    case CookingBookCategory.MISC -> RecipeBookCategories.FURNACE_MISC;
                };
            }
            if ($$2 == RecipeType.f_44109_) {
                return $$4 == CookingBookCategory.BLOCKS ? RecipeBookCategories.BLAST_FURNACE_BLOCKS : RecipeBookCategories.BLAST_FURNACE_MISC;
            }
            if ($$2 == RecipeType.f_44110_) {
                return RecipeBookCategories.SMOKER_FOOD;
            }
            if ($$2 == RecipeType.f_44111_) {
                return RecipeBookCategories.CAMPFIRE;
            }
        }
        if ($$2 == RecipeType.f_44112_) {
            return RecipeBookCategories.STONECUTTER;
        }
        if ($$2 == RecipeType.f_44113_) {
            return RecipeBookCategories.SMITHING;
        }
        f_90618_.warn("Unknown recipe category: {}/{}", LogUtils.defer(() -> BuiltInRegistries.f_256990_.m_7981_(p_90647_.m_6671_())), LogUtils.defer(p_90647_::m_6423_));
        return RecipeBookCategories.UNKNOWN;
    }

    public List<RecipeCollection> m_90639_() {
        return this.f_90620_;
    }

    public List<RecipeCollection> m_90623_(RecipeBookCategories p_90624_) {
        return this.f_90619_.getOrDefault((Object)p_90624_, Collections.emptyList());
    }
}

