/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.placementcondition;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.placementcondition.AllOfPlacementCondition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface PlacementCondition {
    public static final Codec<PlacementCondition> BASE_CODEC = ExtraCodecs.m_184415_(() -> {
        Registry modifierRegistry = (Registry)BuiltInRegistries.f_257047_.m_7745_(LithostitchedRegistryKeys.PLACEMENT_CONDITION_TYPE.m_135782_());
        if (modifierRegistry == null) {
            throw new NullPointerException("Placement modifier registry does not exist yet!");
        }
        return modifierRegistry.m_194605_();
    }).dispatch(PlacementCondition::codec, MapCodec::codec);
    public static final Codec<PlacementCondition> CODEC = LithostitchedCodecs.withAlternative(BASE_CODEC, BASE_CODEC.listOf(), AllOfPlacementCondition::new);

    public boolean test(Context var1, BlockPos var2);

    default public boolean test(Structure.GenerationContext context, BlockPos pos) {
        return this.test(Context.create(context), pos);
    }

    default public boolean test(PlacementContext context, BlockPos pos) {
        return this.test(Context.create(context), pos);
    }

    public MapCodec<? extends PlacementCondition> codec();

    public record Context(RegistryAccess registries, ChunkGenerator generator, LevelHeightAccessor heightAccessor, RandomState randomState, BiomeSource biomeSource, long seed) {
        private static Context create(Structure.GenerationContext context) {
            return new Context(context.f_226621_(), context.f_226622_(), context.f_226629_(), context.f_226624_(), context.f_226623_(), context.f_226627_());
        }

        private static Context create(PlacementContext context) {
            WorldGenLevel level = context.m_191831_();
            return new Context(level.m_9598_(), context.m_191833_(), (LevelHeightAccessor)level, level.m_6018_().m_7726_().m_214994_(), context.m_191833_().m_62218_(), level.m_7328_());
        }
    }
}

