/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.datagen.provider.recipe.tconstruct;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.block.CopperBlockSet;
import ho.artisan.tgears.datagen.provider.recipe.TGBaseRecipeProvider;
import ho.artisan.tgears.index.TGItems;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;

public final class TGMeltingRecipeProvider
extends TGBaseRecipeProvider
implements ISmelteryRecipeHelper {
    public TGMeltingRecipeProvider(PackOutput generator) {
        super(generator);
    }

    @Override
    public String m_6055_() {
        return "TGears Melting Recipes";
    }

    @Override
    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.crushedOreRecipes(consumer);
        this.luzziumRecipes(consumer);
        this.copperRecipes(consumer);
        this.ironRecipes(consumer);
    }

    private void ironRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "melting/iron/";
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AllBlocks.INDUSTRIAL_IRON_BLOCK}), (Fluid)TinkerFluids.moltenIron.get(), (int)40).save(consumer, this.location(folder + "industrial_iron_block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AllBlocks.WEATHERED_IRON_BLOCK}), (Fluid)TinkerFluids.moltenIron.get(), (int)40).save(consumer, this.location(folder + "weathered_iron_block"));
    }

    private void copperRecipes(Consumer<FinishedRecipe> consumer) {
        this.copperRecipe(consumer, AllBlocks.COPPER_TILES);
        this.copperRecipe(consumer, AllBlocks.COPPER_SHINGLES);
    }

    private void copperRecipe(Consumer<FinishedRecipe> consumer, CopperBlockSet set) {
        String folder = "melting/copper/";
        for (WeatheringCopper.WeatherState value : WeatheringCopper.WeatherState.values()) {
            for (CopperBlockSet.Variant variant : CopperBlockSet.DEFAULT_VARIANTS) {
                boolean[] bl;
                for (boolean waxed : bl = new boolean[]{true, false}) {
                    String prefix;
                    String string = prefix = waxed ? "waxed_" : "";
                    int amount = variant == CopperBlockSet.DEFAULT_VARIANTS[0] ? 40 : (variant == CopperBlockSet.DEFAULT_VARIANTS[1] ? 20 : 30);
                    MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{set.get(variant, value, waxed)}), (Fluid)TinkerFluids.moltenCopper.get(), (int)amount).save(consumer, this.location(folder + prefix + set.getName() + "_" + value.name().toLowerCase() + variant.getSuffix()));
                }
            }
        }
    }

    private void luzziumRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "melting/luzzium/";
    }

    private void crushedOreRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "melting/crushed_ore/";
        this.crushedOreRecipeBuilder((ItemLike)TGItems.CRUSHED_RAW_COBALT.get(), TinkerFluids.moltenCobalt.get(), 120, TinkerFluids.moltenDiamond.get(), 25).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[]{IMeltingContainer.OreRateType.GEM}).save(consumer, this.location(folder + "cobalt"));
        this.crushedOreRecipeBuilder((ItemLike)AllItems.CRUSHED_COPPER.get(), TinkerFluids.moltenCopper.get(), 120, TinkerFluids.moltenGold.get(), 60).save(consumer, this.location(folder + "copper"));
        this.crushedOreRecipeBuilder((ItemLike)AllItems.CRUSHED_IRON, TinkerFluids.moltenIron.get(), TinkerFluids.moltenSteel.get()).save(consumer, this.location(folder + "iron"));
        this.crushedOreRecipeBuilder((ItemLike)AllItems.CRUSHED_GOLD, TinkerFluids.moltenGold.get(), TinkerFluids.moltenCobalt.get()).save(consumer, this.location(folder + "gold"));
    }

    public MeltingRecipeBuilder crushedOreRecipeBuilder(ItemLike crushedOre, Fluid moltenFluid, int amount) {
        return MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{crushedOre}), (FluidStack)new FluidStack(moltenFluid, amount), (float)1.0f).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[]{IMeltingContainer.OreRateType.METAL});
    }

    public MeltingRecipeBuilder crushedOreRecipeBuilder(ItemLike crushedOre, Fluid moltenFluid, int amount, Fluid byproductFluid, int byproductAmount) {
        return this.crushedOreRecipeBuilder(crushedOre, moltenFluid, amount).addByproduct(new FluidStack(byproductFluid, byproductAmount));
    }

    public MeltingRecipeBuilder crushedOreRecipeBuilder(ItemLike crushedOre, Fluid moltenFluid, Fluid byproductFluid) {
        return this.crushedOreRecipeBuilder(crushedOre, moltenFluid, 120, byproductFluid, 120);
    }
}

