/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.common.recipe.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ho.artisan.tgears.common.recipe.DismantlingRecipe;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.Nullable;

public class DismantlingRecipeSerializer
implements RecipeSerializer<DismantlingRecipe> {
    public DismantlingRecipe fromJson(ResourceLocation id, JsonObject object) {
        ArrayList<DismantlingRecipe.PartStack> parts = new ArrayList<DismantlingRecipe.PartStack>();
        object.getAsJsonArray("parts").getAsJsonArray().forEach(part -> {
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)part.getAsJsonObject());
            float chance = GsonHelper.m_13820_((JsonObject)object, (String)"chance", (float)1.0f);
            parts.add(new DismantlingRecipe.PartStack(itemstack, chance));
        });
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)object.get("tool"));
        int primary = GsonHelper.m_13824_((JsonObject)object, (String)"primary", (int)0);
        int breakTime = GsonHelper.m_13824_((JsonObject)object, (String)"time", (int)200);
        return new DismantlingRecipe(id, parts, ingredient, primary, breakTime);
    }

    @Nullable
    public DismantlingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        int partsSize = buffer.m_130242_();
        ArrayList<DismantlingRecipe.PartStack> parts = new ArrayList<DismantlingRecipe.PartStack>();
        for (int i = 0; i < partsSize; ++i) {
            ItemStack itemstack = buffer.m_130267_();
            float chance = buffer.readFloat();
            parts.add(new DismantlingRecipe.PartStack(itemstack, chance));
        }
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int primary = buffer.m_130242_();
        int breakTime = buffer.m_130242_();
        return new DismantlingRecipe(id, parts, ingredient, primary, breakTime);
    }

    public void toNetwork(FriendlyByteBuf buf, DismantlingRecipe recipe) {
        buf.m_130130_(recipe.parts().size());
        recipe.parts().forEach(part -> {
            buf.m_130055_(part.stack());
            buf.writeFloat(part.chance());
        });
        recipe.ingredient().m_43923_(buf);
        buf.m_130130_(recipe.primary());
        buf.m_130130_(recipe.time());
    }
}

