/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.loader.forge;

import com.corosus.watut.ParticleRegistry;
import com.corosus.watut.PlayerStatusManagerClient;
import com.corosus.watut.ShaderInstanceBlur;
import com.corosus.watut.WatutMod;
import com.corosus.watut.client.screen.RenderHelper;
import com.corosus.watut.command.CommandWatutReloadJSON;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="watut", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventHandlerForge {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void guiRender(RenderGuiEvent.Post event) {
        WatutMod.getPlayerStatusManagerClient().onGuiRender();
        RenderHelper.guiRender(event.getGuiGraphics());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerCommandsClient(RegisterClientCommandsEvent event) {
        CommandWatutReloadJSON.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMouse(InputEvent.MouseButton.Post event) {
        WatutMod.getPlayerStatusManagerClient().onMouse(event.getAction() != 0);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKey(InputEvent.Key event) {
        WatutMod.getPlayerStatusManagerClient().onKey();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onGameTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WatutMod.getPlayerStatusManagerClient().tickGame();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.player.m_9236_().m_5776_()) {
                WatutMod.getPlayerStatusManagerClient().tickPlayer(event.player);
            } else {
                WatutMod.getPlayerStatusManagerServer().tickPlayer(event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        WatutMod.getPlayerStatusManagerServer().playerLoggedIn(event.getEntity());
    }

    public static void getRegisteredParticles(TextureStitchEvent.Post event) {
        ParticleRegistry.textureAtlasUpload(event.getAtlas());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerShaders(RegisterShadersEvent event) {
        try {
            PlayerStatusManagerClient.particle = null;
            PlayerStatusManagerClient.positionTexBlur = null;
            PlayerStatusManagerClient.positionTexBlurHorizontal = null;
            PlayerStatusManagerClient.positionTexBlurVertical = null;
            PlayerStatusManagerClient.particle = new ShaderInstanceBlur(event.getResourceProvider(), new ResourceLocation("watut:particle"), DefaultVertexFormat.f_85813_);
            PlayerStatusManagerClient.positionTexBlur = new ShaderInstanceBlur(event.getResourceProvider(), new ResourceLocation("watut:position_tex_blur"), DefaultVertexFormat.f_85817_);
            PlayerStatusManagerClient.positionTexBlurHorizontal = new ShaderInstanceBlur(event.getResourceProvider(), new ResourceLocation("watut:position_tex_blur_horizontal"), DefaultVertexFormat.f_85817_);
            PlayerStatusManagerClient.positionTexBlurVertical = new ShaderInstanceBlur(event.getResourceProvider(), new ResourceLocation("watut:position_tex_blur_vertical"), DefaultVertexFormat.f_85817_);
            event.registerShader((ShaderInstance)PlayerStatusManagerClient.particle, shaderInstance -> {});
            event.registerShader((ShaderInstance)PlayerStatusManagerClient.positionTexBlur, shaderInstance -> {});
            event.registerShader((ShaderInstance)PlayerStatusManagerClient.positionTexBlurHorizontal, shaderInstance -> {});
            event.registerShader((ShaderInstance)PlayerStatusManagerClient.positionTexBlurVertical, shaderInstance -> {});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

