/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.silentsdelight.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import com.scouter.silentsdelight.config.SilentsDelightConfig;
import com.scouter.silentsdelight.player.VibrationEntities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="silentsdelight", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    static final Minecraft minecraft = Minecraft.m_91087_();
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void playSound(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (!((Boolean)SilentsDelightConfig.WARDEN_SENSE_SOUND.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        UUID uuid = player.m_20148_();
        Collection<Integer> ids = VibrationEntities.getToShow(uuid);
        if (ids.isEmpty()) {
            return;
        }
        for (Integer id : ids) {
            BlockState state;
            Entity entity = level.m_6815_(id.intValue());
            if (entity == null || (state = entity.m_20075_()).m_60713_(Blocks.f_50016_)) continue;
            SoundEvent event1 = state.m_60827_().m_56776_();
            level.m_245747_(entity.m_20183_(), event1, SoundSource.AMBIENT, ((Float)SilentsDelightConfig.WARDEN_SENSE_SOUND_VOLUME.get()).floatValue(), 1.0f, true);
        }
    }

    @SubscribeEvent
    public static void renderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            if (level == null) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null || player.m_5833_()) {
                return;
            }
            UUID uuid = player.m_20148_();
            Vec3 projectedView = minecraft.f_91063_.m_109153_().m_90583_();
            Collection<Integer> ids = VibrationEntities.getToShow(uuid);
            if (ids.isEmpty()) {
                return;
            }
            RenderBuffers renderBuffers = minecraft.m_91269_();
            MultiBufferSource.BufferSource bufferSource = renderBuffers.m_110104_();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2848);
            GL11.glDisable((int)2929);
            poseStack.m_85836_();
            poseStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer id : ids) {
                Entity entity = level.m_6815_(id.intValue());
                if (entity == null) continue;
                int time = VibrationEntities.getTime(id);
                float multp = 1.0f - (float)time / 50.0f;
                RenderType renderType = RenderType.m_110504_();
                VertexConsumer builder = bufferSource.m_6299_(renderType);
                if (time > 40) {
                    ClientEvents.drawCircle(builder, poseStack, (float)entity.m_20182_().f_82479_, (int)(entity.m_20182_().m_7098_() + 0.004), (float)entity.m_20182_().f_82481_, 0.5f, 5679572);
                    ClientEvents.drawCircle(builder, poseStack, (float)entity.m_20182_().f_82479_, (int)(entity.m_20182_().m_7098_() - 1.0), (float)entity.m_20182_().f_82481_, 0.25f, 5679572);
                    ClientEvents.drawCircle(builder, poseStack, (float)entity.m_20182_().f_82479_, (int)(entity.m_20182_().m_7098_() - 2.0), (float)entity.m_20182_().f_82481_, 0.125f, 5679572);
                } else if (time > 25) {
                    ClientEvents.drawCircle(builder, poseStack, (float)entity.m_20182_().f_82479_, (int)(entity.m_20182_().m_7098_() + 0.004), (float)entity.m_20182_().f_82481_, 1.0f, 5679572);
                    ClientEvents.drawCircle(builder, poseStack, (float)entity.m_20182_().f_82479_, (int)(entity.m_20182_().m_7098_() - 1.0), (float)entity.m_20182_().f_82481_, 0.5f, 5679572);
                    ClientEvents.drawCircle(builder, poseStack, (float)entity.m_20182_().f_82479_, (int)(entity.m_20182_().m_7098_() - 2.0), (float)entity.m_20182_().f_82481_, 0.25f, 5679572);
                } else {
                    ClientEvents.drawCircle(builder, poseStack, (float)entity.m_20182_().f_82479_, (int)(entity.m_20182_().m_7098_() + 0.004), (float)entity.m_20182_().f_82481_, 1.5f, 5679572);
                    ClientEvents.drawCircle(builder, poseStack, (float)entity.m_20182_().f_82479_, (int)(entity.m_20182_().m_7098_() - 1.0), (float)entity.m_20182_().f_82481_, 1.0f, 5679572);
                    ClientEvents.drawCircle(builder, poseStack, (float)entity.m_20182_().f_82479_, (int)(entity.m_20182_().m_7098_() - 2.0), (float)entity.m_20182_().f_82481_, 0.5f, 5679572);
                }
                bufferSource.m_109912_(renderType);
                toRemove.add(id);
            }
            VibrationEntities.remove(uuid, toRemove);
            poseStack.m_85849_();
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)2848);
        }
    }

    public static void drawCircle(VertexConsumer bufferBuilder, PoseStack matrixStack, float centerX, int y, float centerZ, float radius, int color) {
        color = ClientEvents.fixAlpha(color);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        float numPoints = 360.0f;
        float angleIncrement = (float)Math.PI * 2 / numPoints;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        int i = 1;
        while ((float)i <= numPoints) {
            float angle = angleIncrement * (float)i;
            float xd = (float)((double)radius * Math.sin(angle));
            float zd = (float)((double)radius * Math.cos(angle));
            bufferBuilder.m_252986_(matrix, centerX + xd, (float)y, centerZ + zd).m_85950_(r, g, b, a).m_252939_(matrixStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
            ++i;
        }
    }

    public static int fixAlpha(int color) {
        return (color & 0xFF000000) == 0 ? color | 0xFF000000 : color;
    }
}

