/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.entity.custom.bunyip;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.myths_of_the_sea.entity.custom.bunyip.AmphibiousPathNavigation;
import com.cerbon.myths_of_the_sea.entity.custom.bunyip.BunyipBodyRotationControl;
import com.cerbon.myths_of_the_sea.entity.custom.bunyip.goal.BunyipAttackGoal;
import com.cerbon.myths_of_the_sea.entity.custom.bunyip.goal.BunyipStrollGoal;
import com.cerbon.myths_of_the_sea.entity.custom.bunyip.goal.BunyipSwimAroundGoal;
import com.cerbon.myths_of_the_sea.entity.custom.util.WaterOrLandLookControl;
import com.cerbon.myths_of_the_sea.entity.custom.util.WaterOrLandMoveControl;
import com.cerbon.myths_of_the_sea.item.MTSItems;
import com.cerbon.myths_of_the_sea.sound.MTSSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BunyipEntity
extends PathfinderMob
implements GeoEntity,
Enemy {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation MOVE_ANIM = RawAnimation.begin().thenLoop("move");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation DIE_ANIM = RawAnimation.begin().thenPlayAndHold("death");
    private static final int ATTACK_ANIM_TIME = 21;
    private static final RawAnimation IDLE_ANIM_WATER = RawAnimation.begin().thenLoop("idle_swim");
    private static final RawAnimation MOVE_ANIM_WATER = RawAnimation.begin().thenLoop("swim");
    private static final RawAnimation ATTACK_ANIM_WATER = RawAnimation.begin().then("attack_swim", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation DIE_ANIM_WATER = RawAnimation.begin().thenPlayAndHold("die_swim");

    public BunyipEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 1.0f);
        this.m_274367_(1.0f);
        this.f_21342_ = new WaterOrLandMoveControl((Mob)this);
        this.f_21365_ = new WaterOrLandLookControl((Mob)this, 90);
    }

    public static AttributeSupplier createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, 2.0).m_22268_(Attributes.f_22279_, (double)0.21f).m_22268_(Attributes.f_22277_, 48.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BunyipAttackGoal(this, 1.2f, false));
        this.f_21345_.m_25352_(1, (Goal)new BunyipSwimAroundGoal(this, 0.75, 60));
        this.f_21345_.m_25352_(2, (Goal)new BunyipStrollGoal(this, 1.0, 10));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new BunyipBodyRotationControl(this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MTSSounds.BUNYIP_IDLE.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)MTSSounds.BUNYIP_MOVEMENT.get();
    }

    public boolean m_7327_(@NotNull Entity target) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SoundUtils.playSound((ServerLevel)serverLevel, (Vec3)this.m_20182_(), (SoundEvent)((SoundEvent)MTSSounds.BUNYIP_ATTACK.get()), (SoundSource)SoundSource.HOSTILE, (float)3.0f, (double)6.0);
        }
        return super.m_7327_(target);
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)MTSSounds.BUNYIP_DAMAGE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)MTSSounds.BUNYIP_DEATH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 5, state -> {
            if (this.f_20911_ && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                state.getController().forceAnimationReset();
                state.getController().setAnimation(this.m_20069_() ? ATTACK_ANIM_WATER : ATTACK_ANIM);
                CapabilityUtils.getLevelEventScheduler((Level)this.m_9236_()).addEvent((IEvent)new TimedEvent(() -> {
                    this.f_20911_ = false;
                }, 21));
            }
            return PlayState.CONTINUE;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Movement", 10, state -> {
            if (this.m_20069_()) {
                if (this.f_20911_) {
                    return PlayState.STOP;
                }
                if (!state.isMoving()) {
                    return state.setAndContinue(IDLE_ANIM_WATER);
                }
                if (state.isMoving()) {
                    return state.setAndContinue(MOVE_ANIM_WATER);
                }
                return PlayState.STOP;
            }
            if (this.f_20911_) {
                return PlayState.STOP;
            }
            if (!state.isMoving()) {
                return state.setAndContinue(IDLE_ANIM);
            }
            if (state.isMoving()) {
                return state.setAndContinue(MOVE_ANIM);
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Die", 0, state -> {
            if (((BunyipEntity)state.getAnimatable()).m_21224_()) {
                if (this.m_20069_()) {
                    return state.setAndContinue(DIE_ANIM_WATER);
                }
                return state.setAndContinue(DIE_ANIM);
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    protected void m_6153_() {
        CapabilityUtils.getLevelEventScheduler((Level)this.m_9236_()).addEvent((IEvent)new TimedEvent(() -> super.m_6153_(), 40));
    }

    public boolean m_6573_(@NotNull Player player) {
        return false;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)MTSItems.BUNYIP_SPAWN_EGG.get());
    }
}

