/*
 * Decompiled with CFR 0.152.
 */
package com.Portality.ccomunityboxes.painter;

import com.Portality.ccomunityboxes.ponder.BoxScenes;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class PainterBE
extends SmartBlockEntity {
    private boolean finishedCraft = false;
    public int craftProgress = 0;
    public int prevCraftProgress = 0;
    private int maxCraftProgress = 30;
    public ItemStack heldStack = ItemStack.f_41583_;
    public boolean splashed = false;
    public boolean rareSplashed = false;
    private FilteringBehaviour filtering;

    public PainterBE(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new PainterValueBox());
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public ItemStack getRenderedBox() {
        return this.heldStack;
    }

    public void tick() {
        super.tick();
        this.prevCraftProgress = this.craftProgress;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (!(blockEntity instanceof SpoutBlockEntity)) {
            return;
        }
        SpoutBlockEntity spoutBlockEntity = (SpoutBlockEntity)blockEntity;
        if (!this.f_58857_.f_46443_ && PackageItem.isPackage((ItemStack)this.heldStack)) {
            if (this.craftProgress < this.maxCraftProgress) {
                if (this.craftProgress == 5) {
                    if (this.splashed) {
                        ++this.craftProgress;
                        this.splashed = false;
                    }
                } else {
                    ++this.craftProgress;
                }
                if (this.craftProgress == 15) {
                    this.switchBox();
                }
                this.m_6596_();
                this.notifyUpdate();
            } else if (!this.finishedCraft) {
                this.finishedCraft = true;
                this.m_6596_();
                this.notifyUpdate();
            }
        }
    }

    private void switchBox() {
        CompoundTag tag = this.heldStack.m_41784_();
        ItemStack newStack = PackageItem.isPackage((ItemStack)this.filtering.getFilter()) ? this.filtering.getFilter() : BoxScenes.getRandomBox();
        if (!this.rareSplashed) {
            Item item = this.filtering.getFilter().m_41720_();
            if (item instanceof PackageItem) {
                PackageItem packageItem = (PackageItem)item;
                if (packageItem.style.rare()) {
                    newStack = BoxScenes.getRandomBox();
                }
            }
        } else if (!PackageItem.isPackage((ItemStack)this.filtering.getFilter())) {
            newStack = BoxScenes.getRandomRareBox();
        }
        this.rareSplashed = false;
        newStack.m_41751_(tag);
        this.heldStack = newStack;
    }

    public float getInOutProgress(float partialTicks) {
        if (this.craftProgress <= 5) {
            return this.getInterpolated(partialTicks, this.craftProgress, this.prevCraftProgress) - 0.5f;
        }
        if (this.craftProgress >= this.maxCraftProgress - 5) {
            return this.getInterpolated(partialTicks, this.craftProgress - (this.maxCraftProgress - 5), this.prevCraftProgress - (this.maxCraftProgress - 5));
        }
        return 0.0f;
    }

    private float getInterpolated(float pt, int craftProgress, int prevCraftProgress) {
        return Mth.m_14179_((float)pt, (float)prevCraftProgress, (float)craftProgress) * 0.1f;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> new IItemHandler(){
                private final int OUTPUT_SLOT = 0;
                private final int SLOT_COUNT = 1;

                public int getSlots() {
                    return 1;
                }

                @NotNull
                public ItemStack getStackInSlot(int slot) {
                    if (slot == 0) {
                        return PainterBE.this.heldStack;
                    }
                    return ItemStack.f_41583_;
                }

                @NotNull
                public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                    if (!(stack.m_41720_() instanceof PackageItem)) {
                        return stack;
                    }
                    if (PackageItem.isPackage((ItemStack)PainterBE.this.heldStack)) {
                        return stack;
                    }
                    if (!simulate) {
                        PainterBE.this.craftProgress = 0;
                        PainterBE.this.finishedCraft = false;
                    }
                    PainterBE.this.heldStack = stack.m_41777_();
                    PainterBE.this.m_6596_();
                    PainterBE.this.notifyUpdate();
                    ItemStack result = ItemStack.f_41583_;
                    return result;
                }

                @NotNull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (slot != 0 || amount <= 0 || PainterBE.this.heldStack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    if (!PainterBE.this.finishedCraft) {
                        return ItemStack.f_41583_;
                    }
                    ItemStack filter = PainterBE.this.filtering.getFilter();
                    int extractCount = Math.min(amount, PainterBE.this.heldStack.m_41613_());
                    ItemStack extracted = PainterBE.this.heldStack.m_255036_(extractCount);
                    if (!simulate) {
                        PainterBE.this.finishedCraft = false;
                        PainterBE.this.craftProgress = 0;
                        PainterBE.this.prevCraftProgress = 0;
                        PainterBE.this.heldStack.m_41774_(extractCount);
                        if (PainterBE.this.heldStack.m_41619_()) {
                            PainterBE.this.heldStack = ItemStack.f_41583_;
                        }
                        PainterBE.this.m_6596_();
                        PainterBE.this.notifyUpdate();
                    }
                    PainterBE.this.filtering.setFilter(filter);
                    return extracted;
                }

                public int getSlotLimit(int slot) {
                    return 64;
                }

                public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                    return slot == 0 && stack.m_41720_() instanceof PackageItem;
                }
            }).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.finishedCraft = compound.m_128471_("finishedCraft");
        this.craftProgress = compound.m_128451_("craftProgress");
        this.heldStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("heldStack"));
        this.splashed = compound.m_128471_("splashed");
        this.rareSplashed = compound.m_128471_("rareSplashed");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("finishedCraft", this.finishedCraft);
        compound.m_128405_("craftProgress", this.craftProgress);
        compound.m_128365_("heldStack", (Tag)this.heldStack.serializeNBT());
        compound.m_128379_("splashed", this.splashed);
        compound.m_128379_("rareSplashed", this.rareSplashed);
        super.write(compound, clientPacket);
    }

    class PainterValueBox
    extends ValueBoxTransform.Sided {
        PainterValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)4.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.m_122434_().m_122479_();
        }
    }
}

