/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatdelight.register;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fixerlink.compatdelight.Config;
import net.fixerlink.compatdelight.compat.mod.bamboodelight.block.BambooModBlocks;
import net.fixerlink.compatdelight.compat.mod.bamboodelight.item.BambooModItems;
import net.fixerlink.compatdelight.compat.mod.bossdelight.item.BossMobModItems;
import net.fixerlink.compatdelight.compat.mod.cavesdelight.item.CavesModItems;
import net.fixerlink.compatdelight.compat.mod.coraldelight.item.CoralModItems;
import net.fixerlink.compatdelight.compat.mod.flowerdelight.item.FlowerModItems;
import net.fixerlink.compatdelight.compat.mod.ingredientsdelight.item.IngredientsModItems;
import net.fixerlink.compatdelight.compat.mod.naturedelight.item.NatureModItems;
import net.fixerlink.compatdelight.compat.mod.sweetdelight.item.SweetModItems;
import net.fixerlink.compatdelight.compat.mod.vegetablesdelight.block.VegetablesModBlocks;
import net.fixerlink.compatdelight.compat.mod.vegetablesdelight.item.VegetablesModItems;
import net.fixerlink.compatdelight.compat.mod.voiddelight.item.VoidModItems;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ModConfigCompat {
    private static final Map<String, Consumer<IEventBus>> REG = new LinkedHashMap<String, Consumer<IEventBus>>();
    private static final Map<String, Consumer<BuildCreativeModeTabContentsEvent>> CT = new LinkedHashMap<String, Consumer<BuildCreativeModeTabContentsEvent>>();

    public static void registerAll(IEventBus bus) {
        REG.forEach((key, action) -> {
            if (Config.isEnabled(key)) {
                action.accept(bus);
            }
        });
    }

    public static void addCreative(BuildCreativeModeTabContentsEvent e) {
        CT.forEach((key, action) -> {
            if (Config.isEnabled(key)) {
                action.accept(e);
            }
        });
    }

    static {
        REG.put("bamboo_delight", bus -> {
            BambooModItems.register(bus);
            BambooModBlocks.register(bus);
        });
        REG.put("void_delight", bus -> VoidModItems.register(bus));
        REG.put("coral_delight", bus -> CoralModItems.register(bus));
        REG.put("caves_delight", bus -> CavesModItems.register(bus));
        REG.put("boss_delight", bus -> BossMobModItems.register(bus));
        REG.put("flower_delight", bus -> FlowerModItems.register(bus));
        REG.put("nature_delight", bus -> NatureModItems.register(bus));
        REG.put("sweet_delight", bus -> SweetModItems.register(bus));
        REG.put("ingredients_delight", bus -> IngredientsModItems.register(bus));
        REG.put("vegetables_delight", bus -> {
            VegetablesModItems.register(bus);
            VegetablesModBlocks.register(bus);
        });
    }
}

