/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatdelight.register;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fixerlink.compatdelight.Config;
import net.fixerlink.compatdelight.compat.cavebiomesdelight.block.CaveModBlocks;
import net.fixerlink.compatdelight.compat.cavebiomesdelight.item.CaveModItems;
import net.fixerlink.compatdelight.compat.palegardendelight.item.PaleGardenModItems;
import net.fixerlink.compatdelight.compat.ratsdelight.item.RatsModItems;
import net.fixerlink.compatdelight.compat.refinedstoragedelight.item.RSModItems;
import net.fixerlink.compatdelight.compat.regionsunexploreddelight.item.RegionsModItems;
import net.fixerlink.compatdelight.compat.stalwartdungeonsdelight.item.StalwartModItems;
import net.fixerlink.compatdelight.compat.supplementariesdelight.item.SupplementariesModItems;
import net.fixerlink.compatdelight.compat.toughasdelight.item.ToughAsModItems;
import net.fixerlink.compatdelight.compat.tropicraftdelight.item.TropiCraftModItems;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;

public class ModCompatA {
    private static final Map<String, Consumer<IEventBus>> compatMap = new HashMap<String, Consumer<IEventBus>>();

    public static void register(IEventBus modEventBus) {
        for (Map.Entry<String, Consumer<IEventBus>> entry : compatMap.entrySet()) {
            String modid = entry.getKey();
            if (!ModList.get().isLoaded(modid) || !Config.isEnabled(modid)) continue;
            entry.getValue().accept(modEventBus);
        }
    }

    static {
        compatMap.put("rats", bus -> {
            System.out.println("[Compat Delight] Rats detected \u2014 registering compat");
            RatsModItems.register(bus);
        });
        compatMap.put("refinedstorage", bus -> {
            System.out.println("[Compat Delight] Refined Storage detected \u2014 registering compat");
            RSModItems.register(bus);
        });
        compatMap.put("regions_unexplored", bus -> {
            System.out.println("[Compat Delight] Regions Unexplored detected \u2014 registering compat");
            RegionsModItems.register(bus);
        });
        compatMap.put("stalwart_dungeons", bus -> {
            System.out.println("[Compat Delight] Stalwart Dungeons detected \u2014 registering compat");
            StalwartModItems.register(bus);
        });
        compatMap.put("supplementaries", bus -> {
            System.out.println("[Compat Delight] Supplementaries detected \u2014 registering compat");
            SupplementariesModItems.register(bus);
        });
        compatMap.put("toughasnails", bus -> {
            System.out.println("[Compat Delight] Tough As Nails detected \u2014 registering compat");
            ToughAsModItems.register(bus);
        });
        compatMap.put("tropicraft", bus -> {
            System.out.println("[Compat Delight] Tropi Craft detected \u2014 registering compat");
            TropiCraftModItems.register(bus);
        });
        compatMap.put("yungscavebiomes", bus -> {
            System.out.println("[Compat Delight] Yungs Cave Biomes detected \u2014 registering compat");
            CaveModItems.register(bus);
            CaveModBlocks.register(bus);
        });
        compatMap.put("palegarden", bus -> {
            System.out.println("[Compat Delight] Pale Garden detected \u2014 registering compat");
            PaleGardenModItems.register(bus);
        });
    }
}

