/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatdelight.compat.ironsspellsdelight.item.custom;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicProvider;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpellEmpowermentCharm
extends Item {
    private static final Random RANDOM = new Random();
    private static final UUID EMPOWERMENT_UUID = UUID.fromString("6c52b4ba-97b1-4ec6-bc65-abcdef123456");

    public SpellEmpowermentCharm(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Optional magicDataOptional = player.getCapability(PlayerMagicProvider.PLAYER_MAGIC).resolve();
            if (magicDataOptional.isEmpty()) {
                player.m_5661_((Component)Component.m_237115_((String)"item.irons_spellbooks.magic_data_error"), true);
                return stack;
            }
            if (!player.m_36335_().m_41519_((Item)this)) {
                final AttributeInstance attribute = this.selectRandomAttribute(player);
                if (attribute != null) {
                    double boostValue = 0.1 + RANDOM.nextDouble() * 0.15;
                    AttributeModifier modifier = new AttributeModifier(EMPOWERMENT_UUID, "Spell Empowerment", boostValue, AttributeModifier.Operation.ADDITION);
                    attribute.m_22118_(modifier);
                    player.m_5661_((Component)Component.m_237110_((String)"item.irons_spellbooks.spell_empowered", (Object[])new Object[]{attribute.m_22099_().m_22087_(), boostValue}), true);
                    MinecraftForge.EVENT_BUS.register(new Object(){
                        int ticks = 1200;

                        @SubscribeEvent
                        public void onTick(TickEvent.ServerTickEvent event) {
                            if (event.phase == TickEvent.Phase.END) {
                                --this.ticks;
                                if (this.ticks <= 0) {
                                    attribute.m_22120_(EMPOWERMENT_UUID);
                                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                                }
                            }
                        }
                    });
                }
                player.m_36335_().m_41524_((Item)this, 1200);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.irons_spellbooks.on_cooldown"), true);
            }
        }
        return super.m_5922_(stack, level, entity);
    }

    private AttributeInstance selectRandomAttribute(ServerPlayer player) {
        AttributeInstance[] attributes = new AttributeInstance[]{player.m_21051_((Attribute)AttributeRegistry.FIRE_SPELL_POWER.get()), player.m_21051_((Attribute)AttributeRegistry.ICE_SPELL_POWER.get()), player.m_21051_((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get()), player.m_21051_((Attribute)AttributeRegistry.HOLY_SPELL_POWER.get()), player.m_21051_((Attribute)AttributeRegistry.ENDER_SPELL_POWER.get()), player.m_21051_((Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get()), player.m_21051_((Attribute)AttributeRegistry.NATURE_SPELL_POWER.get())};
        AttributeInstance selected = null;
        while (selected == null && attributes.length > 0) {
            selected = attributes[RANDOM.nextInt(attributes.length)];
        }
        return selected;
    }
}

