/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatdelight.compat.cavebiomesdelight.block.custom;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystalBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)4);
    private final List<Supplier<Item>> servingItems;
    private final boolean hasLeftovers;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)};

    public CrystalBlock(BlockBehaviour.Properties properties, List<Supplier<Item>> servingItems, boolean hasLeftovers) {
        super(properties);
        this.servingItems = servingItems;
        this.hasLeftovers = hasLeftovers;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(SHAPES.length - 1)));
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    public int getMaxServings() {
        return Math.max(1, Math.min(4, this.servingItems.size()));
    }

    private int nextItemIndex(BlockState state) {
        int visual = (Integer)state.m_61143_((Property)SERVINGS);
        int clickNum = SHAPES.length - 1 - visual + 1;
        int max = this.getMaxServings();
        return clickNum >= 1 && clickNum <= max ? clickNum - 1 : -1;
    }

    public ItemStack getServingItem(BlockState state) {
        int idx = this.nextItemIndex(state);
        return idx >= 0 ? new ItemStack((ItemLike)this.servingItems.get(idx).get()) : ItemStack.f_41583_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int i = Math.max(0, Math.min((Integer)state.m_61143_((Property)SERVINGS), SHAPES.length - 1));
        return SHAPES[i];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return level.f_46443_ && this.takeServing((LevelAccessor)level, pos, state, player, hand).m_19077_() ? InteractionResult.SUCCESS : this.takeServing((LevelAccessor)level, pos, state, player, hand);
    }

    protected InteractionResult takeServing(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int visual = (Integer)state.m_61143_((Property)SERVINGS);
        if (visual == 0) {
            level.m_5594_(null, pos, SoundEvents.f_12630_, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.m_46961_(pos, true);
            return InteractionResult.SUCCESS;
        }
        int idx = this.nextItemIndex(state);
        if (idx >= 0) {
            ItemStack serving = new ItemStack((ItemLike)this.servingItems.get(idx).get());
            if (!player.m_150109_().m_36054_(serving)) {
                player.m_36176_(serving, false);
            }
        }
        int newVisual = Math.max(0, visual - 1);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(newVisual)), 3);
        level.m_5594_(null, pos, SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (newVisual == 0 && !this.hasLeftovers) {
            level.m_7471_(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(SHAPES.length - 1));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SERVINGS});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)SERVINGS);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

