/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatdelight;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="compatdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final Map<String, ForgeConfigSpec.BooleanValue> MOD_FLAGS = new LinkedHashMap<String, ForgeConfigSpec.BooleanValue>();
    public static final Map<String, Boolean> MOD_ENABLED = new HashMap<String, Boolean>();
    private static final String[] ALL_MODIDS = new String[]{"ad_astra", "apotheosis", "ae2", "ars_nouveau", "biomesoplenty", "bloodmagic", "blue_skies", "born_in_chaos_v1", "bosses_of_mass_destruction", "botania", "the_bumblezone", "bygonenether", "conjurer_illager", "cyclic", "deeperdarker", "draconicevolution", "ecologics", "enderio", "enigmaticlegacy", "enlightened_end", "evilcraft", "bigreactors", "forbidden_arcanus", "friendsandfoes", "graveyard", "hexerei", "irons_spellbooks", "legendarycreatures", "malum", "mekanism", "midnight", "mowziesmobs", "mutantmonsters", "mysticalagriculture", "naturalist", "naturesaura", "nourished_nether", "occultism", "biomeswevegone", "outer_end", "rats", "refinedstorage", "regions_unexplored", "stalwart_dungeons", "supplementaries", "toughasnails", "tropicraft", "yungscavebiomes", "palegarden"};
    private static final Map<String, ForgeConfigSpec.BooleanValue> FEATURE_FLAGS = new LinkedHashMap<String, ForgeConfigSpec.BooleanValue>();
    public static final Map<String, Boolean> FEATURE_ENABLED = new HashMap<String, Boolean>();
    public static final ForgeConfigSpec SPEC;

    private static void toggleFeature(String key, boolean def, String comment) {
        FEATURE_FLAGS.put(key, BUILDER.comment(comment).define(key, def));
    }

    public static boolean isCompatEnabled(String modid) {
        ForgeConfigSpec.BooleanValue v = MOD_FLAGS.get(modid);
        return v == null || (Boolean)v.get() != false;
    }

    public static boolean isFeatureEnabled(String key) {
        ForgeConfigSpec.BooleanValue v = FEATURE_FLAGS.get(key);
        return v == null || (Boolean)v.get() != false;
    }

    public static boolean isEnabled(String key) {
        if (MOD_FLAGS.containsKey(key)) {
            return Config.isCompatEnabled(key);
        }
        return Config.isFeatureEnabled(key);
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
    }

    static {
        BUILDER.push("compat");
        for (String modid : ALL_MODIDS) {
            MOD_FLAGS.put(modid, BUILDER.comment("Enable compat registrations for '" + modid + "'").define(modid, true));
        }
        BUILDER.pop();
        BUILDER.push("features");
        Config.toggleFeature("void_delight", true, "Expose Void Delight");
        Config.toggleFeature("bamboo_delight", true, "Expose Bamboo Delight");
        Config.toggleFeature("coral_delight", true, "Expose Coral Delight");
        Config.toggleFeature("caves_delight", true, "Expose Caves Delight");
        Config.toggleFeature("boss_delight", true, "Expose Boss Delight");
        Config.toggleFeature("flower_delight", true, "Expose Flower Delight");
        Config.toggleFeature("nature_delight", true, "Expose Nature Delight");
        Config.toggleFeature("sweet_delight", true, "Expose Sweet Delight");
        Config.toggleFeature("vegetables_delight", true, "Expose Vegetables Delight");
        Config.toggleFeature("ingredients_delight", true, "Expose Ingredients Delight");
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

