/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.util.texture;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.infernalstudios.questlog.Questlog;
import org.infernalstudios.questlog.util.texture.Blittable;

public class ItemRenderable
implements Blittable {
    private final ResourceLocation item;
    private ItemStack cachedStack;

    public ItemRenderable(ResourceLocation item) {
        this.item = item;
    }

    @Nullable
    private ItemStack getItem() {
        if (this.cachedStack == null) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(this.item);
            if (item != Items.f_41852_) {
                this.cachedStack = item.m_7968_();
            } else {
                Questlog.LOGGER.warn("Item {} not found", (Object)this.item);
            }
        }
        return this.cachedStack;
    }

    @Override
    public int width() {
        return 16;
    }

    @Override
    public int height() {
        return 16;
    }

    @Override
    public void blit(GuiGraphics ps, int x, int y) {
        ItemStack item = this.getItem();
        if (item == null) {
            return;
        }
        ps.m_280480_(item, x, y);
    }
}

