/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public final class Util {
    private static final Gson GSON = new GsonBuilder().create();

    private Util() {
    }

    @CheckForNull
    public static StatsCounter getStats(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.m_8951_();
        }
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            return localPlayer.m_108630_();
        }
        return null;
    }

    public static <T> List<T> invertList(List<T> list) {
        ArrayList<T> inverted = new ArrayList<T>(list.size());
        for (int i = list.size() - 1; i >= 0; --i) {
            inverted.add(list.get(i));
        }
        return inverted;
    }

    public static <T> Tag toNbtList(List<T> list, Function<T, Tag> serializer) {
        ListTag tag = new ListTag();
        tag.addAll(list.stream().map(serializer).toList());
        return tag;
    }

    public static JsonObject getJsonResource(Resource resource) throws IOException {
        JsonObject jsonObject;
        block8: {
            InputStream stream = resource.m_215507_();
            try {
                jsonObject = (JsonObject)GSON.fromJson(new String(stream.readAllBytes(), StandardCharsets.UTF_8), JsonObject.class);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedJsonException e) {
                    throw new MalformedJsonException("Malformed JSON in resource " + resource, (Throwable)e);
                }
            }
            stream.close();
        }
        return jsonObject;
    }

    public static JsonObject getJsonResource(ResourceManager manager, ResourceLocation id) throws IOException {
        ResourceLocation path = new ResourceLocation(id.m_135827_(), id.m_135815_() + ".json");
        List resources = manager.m_213829_(path);
        if (resources.isEmpty()) {
            throw new IOException("Resource not found: " + path);
        }
        if (resources.size() > 1) {
            throw new IOException("Multiple resources found: " + path);
        }
        return Util.getJsonResource((Resource)resources.get(0));
    }

    public static BoundingBox bbFromJson(JsonElement json) {
        if (json instanceof JsonObject) {
            int temp;
            int z2;
            JsonObject jsonObject = (JsonObject)json;
            int x1 = jsonObject.has("x1") ? jsonObject.get("x1").getAsInt() : Integer.MIN_VALUE;
            int y1 = jsonObject.has("y1") ? jsonObject.get("y1").getAsInt() : Integer.MIN_VALUE;
            int z1 = jsonObject.has("z1") ? jsonObject.get("z1").getAsInt() : Integer.MIN_VALUE;
            int x2 = jsonObject.has("x2") ? jsonObject.get("x2").getAsInt() : Integer.MAX_VALUE;
            int y2 = jsonObject.has("y2") ? jsonObject.get("y2").getAsInt() : Integer.MAX_VALUE;
            int n = z2 = jsonObject.has("z2") ? jsonObject.get("z2").getAsInt() : Integer.MAX_VALUE;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
            }
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
            }
            if (z1 > z2) {
                temp = z1;
                z1 = z2;
                z2 = temp;
            }
            return new BoundingBox(x1, y1, z1, x2, y2, z2);
        }
        return new BoundingBox(0, 0, 0, 0, 0, 0);
    }

    public static void giveToPlayer(ServerPlayer player, ItemStack item) {
        boolean added = player.m_150109_().m_36054_(item);
        if (added && item.m_41619_()) {
            item.m_41764_(1);
            ItemEntity itemEntity = player.m_36176_(item, false);
            if (itemEntity != null) {
                itemEntity.m_32065_();
            }
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            player.f_36096_.m_38946_();
        } else {
            ItemEntity itemEntity = player.m_36176_(item, false);
            if (itemEntity != null) {
                itemEntity.m_32061_();
                itemEntity.m_266426_(player.m_20148_());
            }
        }
    }
}

