/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.util;

import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.infernalstudios.questlog.util.CachedValue;

public class CachedRegistryPredicate<T> {
    private final boolean isTag;
    private final CachedValue<T> entry;
    private final CachedValue<TagKey<T>> tag;
    private final BiPredicate<T, T> test;
    private final BiPredicate<TagKey<T>, T> tagTest;

    public CachedRegistryPredicate(String location, Registry<T> registry, BiPredicate<T, T> test, BiPredicate<TagKey<T>, T> tagTest) {
        if (location.startsWith("#")) {
            this.isTag = true;
            location = location.substring(1);
        } else {
            this.isTag = false;
        }
        ResourceLocation key = new ResourceLocation(location);
        this.entry = new CachedValue<Object>(() -> registry.m_7745_(key));
        this.tag = new CachedValue<TagKey>(() -> TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)key));
        this.tagTest = tagTest;
        this.test = test;
    }

    public static CachedRegistryPredicate<Item> item(String location) {
        return new CachedRegistryPredicate<Item>(location, (Registry<Item>)BuiltInRegistries.f_257033_, Objects::equals, (BiPredicate<TagKey<Item>, Item>)((BiPredicate<TagKey, Item>)(tag, item) -> item.m_7968_().m_204117_(tag)));
    }

    public static CachedRegistryPredicate<Block> block(String location) {
        return new CachedRegistryPredicate<Block>(location, (Registry<Block>)BuiltInRegistries.f_256975_, Objects::equals, (BiPredicate<TagKey<Block>, Block>)((BiPredicate<TagKey, Block>)(tag, block) -> block.m_49966_().m_204336_(tag)));
    }

    public boolean test(T value) {
        if (this.isTag) {
            return this.tagTest.test((TagKey<TagKey<T>>)this.tag.get(), (TagKey<T>)value);
        }
        return this.test.test(this.entry.get(), value);
    }
}

