/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.network.packet;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.infernalstudios.questlog.Questlog;
import org.infernalstudios.questlog.core.QuestManager;
import org.infernalstudios.questlog.core.ServerPlayerManager;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.core.quests.rewards.Reward;
import org.infernalstudios.questlog.network.IPacketContext;

public class QuestRewardCollectPacket {
    public static final IPacketContext.Direction DIRECTION = IPacketContext.Direction.CLIENT_TO_SERVER;
    private final ResourceLocation id;
    private final int rewardIndex;

    public QuestRewardCollectPacket(ResourceLocation id, int rewardIndex) {
        this.id = id;
        this.rewardIndex = rewardIndex;
    }

    public static QuestRewardCollectPacket decode(FriendlyByteBuf buf) {
        return new QuestRewardCollectPacket(buf.m_130281_(), buf.readInt());
    }

    public static void handle(QuestRewardCollectPacket packet, IPacketContext ctx) {
        QuestManager manager = ServerPlayerManager.INSTANCE.getManagerByPlayer(Objects.requireNonNull(ctx.getSender()));
        Quest quest = manager.getQuest(packet.id);
        if (quest == null) {
            Questlog.LOGGER.warn("Quest {} not found", (Object)packet.id);
            return;
        }
        Reward reward = quest.rewards.get(packet.rewardIndex);
        if (reward == null) {
            Questlog.LOGGER.warn("Reward {} not found in quest {}", (Object)packet.rewardIndex, (Object)packet.id);
            return;
        }
        if (!reward.hasRewarded()) {
            reward.applyReward((ServerPlayer)manager.player);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        buf.writeInt(this.rewardIndex);
    }
}

