/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.jodah.typetools.TypeResolver;
import org.infernalstudios.questlog.Questlog;
import org.infernalstudios.questlog.event.events.QLEvent;

public class QuestlogEventBus {
    private final Map<Class<?>, List<Consumer<? extends QLEvent>>> listeners = new HashMap();

    public <T extends QLEvent> void addListener(Consumer<T> listener) {
        Class eventClass = TypeResolver.resolveRawArgument(Consumer.class, listener.getClass());
        if (eventClass == null || eventClass == TypeResolver.Unknown.class) {
            throw new IllegalArgumentException("Could not resolve event class for listener " + listener);
        }
        this.addListener(eventClass, listener);
    }

    public <T extends QLEvent> void addListener(Class<T> eventClass, Consumer<T> listener) {
        if (eventClass.isAssignableFrom(QLEvent.class)) {
            Questlog.LOGGER.warn("Registering an event of class {} which is not a subclass of QLEvent", eventClass);
        }
        List listeners = this.listeners.computeIfAbsent(eventClass, k -> new ArrayList(1));
        listeners.add(listener);
    }

    public <T extends QLEvent> void post(T event) {
        List<Consumer<? extends QLEvent>> listeners = this.listeners.get(event.getClass());
        if (listeners != null) {
            for (Consumer<? extends QLEvent> listener : listeners) {
                listener.accept(event);
            }
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }
}

