/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.objectives.misc;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.infernalstudios.questlog.core.quests.objectives.Objective;
import org.infernalstudios.questlog.event.QuestlogEventBus;
import org.infernalstudios.questlog.event.events.QLPlayerEvent;
import org.infernalstudios.questlog.util.JsonUtils;

public class VisitStructureObjective
extends Objective {
    private final ResourceKey<Structure> structure;
    private int ticksUntilCheck = 0;

    public VisitStructureObjective(JsonObject definition) {
        super(definition);
        this.structure = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(JsonUtils.getString(definition, "structure")));
    }

    @Override
    public void registerEventListeners(QuestlogEventBus bus) {
        super.registerEventListeners(bus);
        bus.addListener(this::onPlayerMove);
    }

    private void onPlayerMove(QLPlayerEvent.Tick event) {
        ServerPlayer player;
        if (this.isCompleted() || this.getParent() == null) {
            return;
        }
        Player player2 = event.player;
        if (player2 instanceof ServerPlayer && this.getParent().manager.player.equals((Object)(player = (ServerPlayer)player2)) && --this.ticksUntilCheck <= 0) {
            this.ticksUntilCheck = 20;
            if (!player.m_284548_().m_46749_(player.m_20183_())) {
                return;
            }
            if (!player.m_284548_().m_215010_().m_220488_(player.m_20183_(), this.structure).m_73603_()) {
                return;
            }
            this.setUnits(this.getUnits() + 1);
        }
    }
}

