/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.objectives.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.infernalstudios.questlog.core.quests.objectives.Objective;
import org.infernalstudios.questlog.event.QuestlogEventBus;
import org.infernalstudios.questlog.event.events.QLPlayerEvent;
import org.infernalstudios.questlog.util.JsonUtils;
import org.infernalstudios.questlog.util.Util;

public class VisitPositionObjective
extends Objective {
    private final BoundingBox bounds;
    private int ticksUntilCheck = 0;

    public VisitPositionObjective(JsonObject definition) {
        super(definition);
        this.bounds = Util.bbFromJson((JsonElement)JsonUtils.getObject(definition, "bounds"));
    }

    @Override
    public void registerEventListeners(QuestlogEventBus bus) {
        super.registerEventListeners(bus);
        bus.addListener(this::onPlayerMove);
    }

    private void onPlayerMove(QLPlayerEvent.Tick event) {
        ServerPlayer player;
        if (this.isCompleted() || this.getParent() == null) {
            return;
        }
        Player player2 = event.player;
        if (player2 instanceof ServerPlayer && this.getParent().manager.player.equals((Object)(player = (ServerPlayer)player2)) && --this.ticksUntilCheck <= 0) {
            if (this.bounds.m_71051_((Vec3i)event.player.m_20183_())) {
                this.setUnits(this.getUnits() + 1);
            }
            this.ticksUntilCheck = 20;
        }
    }
}

