/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.objectives.misc;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import org.infernalstudios.questlog.Questlog;
import org.infernalstudios.questlog.core.quests.objectives.Objective;
import org.infernalstudios.questlog.event.QuestlogEventBus;
import org.infernalstudios.questlog.event.events.QLPlayerEvent;
import org.infernalstudios.questlog.util.JsonUtils;
import org.infernalstudios.questlog.util.Util;

public class StatisticObjective
extends Objective {
    private final ResourceLocation stat;
    private int statAtStart = 0;
    private boolean trackSinceStart = true;

    public StatisticObjective(JsonObject definition) {
        super(definition);
        ResourceLocation id = new ResourceLocation(JsonUtils.getString(definition, "stat"));
        this.stat = (ResourceLocation)BuiltInRegistries.f_256771_.m_7745_(id);
        if (this.stat == null) {
            Questlog.LOGGER.warn("Stat id '{}' was not found.", (Object)id);
        }
        if (definition.has("trackSinceStart")) {
            this.trackSinceStart = JsonUtils.getBoolean(definition, "trackSinceStart");
        }
    }

    @Override
    public void registerEventListeners(QuestlogEventBus bus) {
        super.registerEventListeners(bus);
        bus.addListener(this::onStatAward);
    }

    private void onStatAward(QLPlayerEvent.StatAward event) {
        ServerPlayer player;
        if (this.isCompleted() || this.getParent() == null) {
            return;
        }
        Player player2 = event.player;
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).equals((Object)this.getParent().manager.player) && event.stat.equals(this.getStat())) {
            this.setUnits(this.getUnits() + event.amount);
        }
    }

    private Stat<ResourceLocation> getStat() {
        return Stats.f_12988_.m_12902_((Object)this.stat);
    }

    private int getStatValue() {
        return Objects.requireNonNull(Util.getStats(Objects.requireNonNull(this.getParent()).manager.player)).m_13015_(this.getStat());
    }

    @Override
    public void writeInitialData(CompoundTag data) {
        super.writeInitialData(data);
        if (this.trackSinceStart) {
            this.statAtStart = this.getStatValue();
            data.m_128405_("statAtStart", this.statAtStart);
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag data = super.serialize();
        if (this.trackSinceStart) {
            data.m_128405_("statAtStart", this.statAtStart);
        }
        return data;
    }

    @Override
    public void deserialize(CompoundTag data) {
        super.deserialize(data);
        if (this.trackSinceStart) {
            this.statAtStart = data.m_128451_("statAtStart");
        }
    }
}

