/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.objectives.item;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.infernalstudios.questlog.core.quests.objectives.item.AbstractItemObjective;
import org.infernalstudios.questlog.event.QuestlogEventBus;
import org.infernalstudios.questlog.event.events.QLPlayerEvent;

public class ItemObtainObjective
extends AbstractItemObjective {
    @Nullable
    private String uniqueTagCache = null;
    private int ticksUntilCheck = 0;

    public ItemObtainObjective(JsonObject definition) {
        super(definition);
    }

    private String getUniqueTag() {
        if (this.uniqueTagCache == null) {
            this.uniqueTagCache = "questlog_tracked_" + Objects.hash(this.getTotalUnits(), Objects.requireNonNull(this.getParent()).getId(), this.getParent().objectives.indexOf(this), this.getParent().manager.player.m_20148_());
        }
        return this.uniqueTagCache;
    }

    @Override
    public void registerEventListeners(QuestlogEventBus bus) {
        super.registerEventListeners(bus);
        bus.addListener(this::onPlayerTick);
    }

    private void onPlayerTick(QLPlayerEvent.Tick event) {
        ServerPlayer player;
        if (this.isCompleted() || this.getParent() == null) {
            return;
        }
        Player player2 = event.player;
        if (player2 instanceof ServerPlayer && this.getParent().manager.player.equals((Object)(player = (ServerPlayer)player2)) && --this.ticksUntilCheck <= 0) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (!this.test(stack)) continue;
                stacks.add(stack);
            }
            for (ItemStack stack : stacks) {
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_(this.getUniqueTag()) && stack.m_41783_().m_128471_(this.getUniqueTag())) continue;
                this.setUnits(this.getUnits() + stack.m_41613_());
                stack.m_41700_(this.getUniqueTag(), (Tag)ByteTag.f_128257_);
            }
            this.ticksUntilCheck = 20;
        }
    }
}

