/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.display;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.infernalstudios.questlog.core.quests.rewards.Reward;
import org.infernalstudios.questlog.util.JsonUtils;
import org.infernalstudios.questlog.util.texture.Blittable;
import org.jetbrains.annotations.Nullable;

public class RewardDisplayData {
    private final Component name;
    @javax.annotation.Nullable
    private final Blittable icon;
    @javax.annotation.Nullable
    private final ResourceLocation claimSound;
    @javax.annotation.Nullable
    private Reward reward;

    public RewardDisplayData(JsonObject data) {
        String name = JsonUtils.getOrDefault(data, "name", (String)null);
        this.name = name == null ? Component.m_237115_((String)"questlog.reward.default") : (JsonUtils.getOrDefault(data, "translatable", false) ? Component.m_237115_((String)name) : Component.m_237113_((String)name));
        this.icon = JsonUtils.getIcon(data, "icon");
        String sound = JsonUtils.getOrDefault(JsonUtils.getOrDefault(data, "sound", new JsonObject()), "claimed", (String)null);
        this.claimSound = sound == null ? null : new ResourceLocation(sound);
    }

    public void setReward(@Nullable Reward reward) {
        this.reward = reward;
    }

    public Component getName() {
        return this.name;
    }

    public boolean hasRewarded() {
        if (this.reward == null) {
            throw new IllegalStateException("RewardDisplayData has not been assigned a reward");
        }
        return this.reward.hasRewarded();
    }

    @javax.annotation.Nullable
    public Blittable getIcon() {
        return this.icon;
    }

    @javax.annotation.Nullable
    public SoundEvent getClaimSound() {
        return (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(this.claimSound);
    }
}

