/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.infernalstudios.questlog.Questlog;
import org.infernalstudios.questlog.QuestlogEvents;
import org.infernalstudios.questlog.core.DefinitionUtil;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.event.events.QuestEvent;
import org.infernalstudios.questlog.network.packet.QuestDataPacket;
import org.infernalstudios.questlog.network.packet.QuestRemovePacket;
import org.infernalstudios.questlog.platform.Services;

public class QuestManager {
    public final Player player;
    private final Map<ResourceLocation, Quest> quests = new LinkedHashMap<ResourceLocation, Quest>();

    public QuestManager(Player player) {
        this.player = player;
    }

    public void addQuest(Quest quest) {
        if (this.quests.containsKey(quest.getId())) {
            return;
        }
        this.quests.put(quest.getId(), quest);
    }

    public void removeQuest(ResourceLocation id) {
        this.quests.remove(id);
    }

    public Quest getQuest(ResourceLocation id) {
        return this.quests.get(id);
    }

    public boolean isClient() {
        return this.player.m_7578_();
    }

    public List<Quest> getAllQuests() {
        return new ArrayList<Quest>(this.quests.values());
    }

    public void createAllQuests() {
        List<ResourceLocation> ids = DefinitionUtil.getCachedKeys();
        for (ResourceLocation id : ids) {
            Quest quest;
            if (this.quests.containsKey(id)) continue;
            JsonObject definition = DefinitionUtil.getCached(id);
            try {
                quest = Quest.create(definition, id, this);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create quest " + id, e);
            }
            CompoundTag data = new CompoundTag();
            quest.writeInitialData(data);
            quest.deserialize(data);
            this.addQuest(quest);
        }
    }

    public void sync() {
        for (ResourceLocation id : this.quests.keySet()) {
            this.sync(id);
        }
    }

    public void sync(ResourceLocation id) {
        if (!this.isClient() && this.player instanceof ServerPlayer) {
            Questlog.LOGGER.trace("Syncing quest data for {} to client", (Object)id);
            Quest quest = this.quests.get(id);
            if (quest == null) {
                Services.PLATFORM.sendPacketToClient((ServerPlayer)this.player, new QuestRemovePacket(id));
                Questlog.LOGGER.warn("Quest {} not found in manager, removing from client", (Object)id);
            } else {
                CompoundTag data = this.getQuest(id).serialize();
                Services.PLATFORM.sendPacketToClient((ServerPlayer)this.player, new QuestDataPacket(id, data));
                Questlog.LOGGER.trace("Sent quest data for {} to client", (Object)id);
                if (!quest.hasSentTrigger && quest.isTriggered()) {
                    quest.hasSentTrigger = true;
                    QuestlogEvents.onQuestTriggered(new QuestEvent.Triggered(this.player, quest, true));
                    Questlog.LOGGER.trace("Sent quest triggered event for {}", (Object)id);
                }
                if (!quest.hasSentCompletion && quest.isCompleted()) {
                    quest.hasSentCompletion = true;
                    QuestlogEvents.onQuestCompleted(new QuestEvent.Completed(this.player, quest, true));
                    Questlog.LOGGER.trace("Sent quest completed event for {}", (Object)id);
                }
            }
        }
    }
}

