/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.client.gui.components.scrollable;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.infernalstudios.questlog.client.gui.components.ScrollableComponent;
import org.jetbrains.annotations.NotNull;

public class ScrollableText
implements ScrollableComponent.Scrollable {
    private final Font font;
    private final FormattedText text;
    private final int color;
    @Nullable
    private List<FormattedCharSequence> lines;
    private ScrollableComponent scroller;

    public ScrollableText(Font font, FormattedText text, int color) {
        this.font = font;
        this.text = text;
        this.color = color;
    }

    private int getWidth() {
        return this.scroller.width - this.scroller.getScrollbarWidth();
    }

    private List<FormattedCharSequence> getLines() {
        if (this.lines == null) {
            this.lines = this.font.m_92923_(this.text, this.getWidth());
        }
        return this.lines;
    }

    public void m_88315_(@NotNull GuiGraphics ps, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.getLines().size(); ++i) {
            int n = (int)this.scroller.getXOffset();
            int n2 = (int)this.scroller.getYOffset();
            Objects.requireNonNull(this.font);
            ps.m_280649_(this.font, this.getLines().get(i), n, n2 + i * 9, this.color, false);
        }
    }

    @Override
    public int getHeight() {
        int n = this.getLines().size();
        Objects.requireNonNull(this.font);
        return n * 9;
    }

    @Override
    public void setScrollableComponent(ScrollableComponent component) {
        this.scroller = component;
    }
}

