/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data.compat;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;

public class BetterCombatWeaponAttributesProvider
implements DataProvider {
    protected final PackOutput output;
    protected final String modId;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    protected final Map<ResourceLocation, String> datas = Maps.newLinkedHashMap();

    public BetterCombatWeaponAttributesProvider(PackOutput output, ExistingFileHelper existingFileHelper, String modId) {
        this.output = output;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "weapon_attributes");
    }

    public void addData(Item item, String attribute) {
        this.datas.computeIfAbsent(ForgeRegistries.ITEMS.getKey((Object)item), loc -> {
            this.existingFileHelper.trackGenerated(loc, this.resourceType);
            return attribute;
        });
    }

    public void addDatas() {
    }

    public String m_6055_() {
        return "SIMPLE Better Combat Weapon Attributes Provider";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.datas.clear();
        this.addDatas();
        Path outputFolder = this.output.m_245114_();
        ArrayList futureList = Lists.newArrayList();
        this.datas.forEach((loc, data) -> {
            String pathString = String.join((CharSequence)"/", PackType.SERVER_DATA.m_10305_(), loc.m_135827_(), "weapon_attributes", loc.m_135815_() + ".json");
            Path path = outputFolder.resolve(pathString);
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("parent", data);
            futureList.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)jsonObj, (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futureList.stream().toArray(CompletableFuture[]::new));
    }
}

