/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.tleveling.event;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.command.ConfigCommand;
import net.redfox.tleveling.command.ExpGetCommand;
import net.redfox.tleveling.command.ExpSetCommand;
import net.redfox.tleveling.command.LevelGetCommand;
import net.redfox.tleveling.command.LevelSetCommand;
import net.redfox.tleveling.command.LevelupCommand;
import net.redfox.tleveling.leveling.ToolLeveling;
import net.redfox.tleveling.leveling.TooltipHandler;
import net.redfox.tleveling.util.ModTags;

public class ModEvents {

    @Mod.EventBusSubscriber(modid="tleveling")
    public static class ForgeEvents {
        private static boolean blockSkip = true;

        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            if (player.m_21205_().m_204117_(ModTags.Items.TINKERS_MINING)) {
                if (blockSkip) {
                    blockSkip = false;
                    return;
                }
                blockSkip = true;
                new ToolLeveling(player, event.getState());
            }
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            Entity entity = event.getSource().m_7639_();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            if (event.getEntity().m_6095_().m_204039_(ModTags.EntityTypes.EXCLUDED_ENTITIES)) {
                return;
            }
            if (player.m_21205_().m_204117_(ModTags.Items.TINKERS_WEAPONS)) {
                new ToolLeveling(player, (Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onTakeDamage(LivingHurtEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            new ToolLeveling(player, event.getAmount(), player.m_6844_(EquipmentSlot.HEAD));
            new ToolLeveling(player, event.getAmount(), player.m_6844_(EquipmentSlot.CHEST));
            new ToolLeveling(player, event.getAmount(), player.m_6844_(EquipmentSlot.LEGS));
            new ToolLeveling(player, event.getAmount(), player.m_6844_(EquipmentSlot.FEET));
        }

        @SubscribeEvent
        public static void onToolTip(ItemTooltipEvent event) {
            if (event.getEntity() == null) {
                return;
            }
            if (!event.getItemStack().m_204117_(ModTags.Items.ALL_TOOLS)) {
                return;
            }
            long window = Minecraft.m_91087_().m_91268_().m_85439_();
            if (InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344) || InputConstants.m_84830_((long)window, (int)341) || InputConstants.m_84830_((long)window, (int)345)) {
                return;
            }
            ItemStack stack = event.getItemStack();
            List tooltip = event.getToolTip();
            if (InputConstants.m_84830_((long)window, (int)342) || InputConstants.m_84830_((long)window, (int)346)) {
                TooltipHandler.handleExpTooltip(event, (Component)tooltip.get(0), stack);
            } else {
                TooltipHandler.appendAltTooltip(tooltip);
            }
        }

        @SubscribeEvent
        public static void onCommandsRegister(RegisterCommandsEvent event) {
            new ExpSetCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new ExpGetCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new LevelGetCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new LevelSetCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new LevelupCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            ConfigCommand.register((CommandDispatcher)event.getDispatcher());
        }
    }
}

