/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import earth.terrarium.cadmus.Cadmus;
import earth.terrarium.cadmus.api.claims.ClaimApi;
import earth.terrarium.cadmus.api.claims.InteractionType;
import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import earth.terrarium.cadmus.common.claims.CadmusDataHandler;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimSettings;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.commands.ModCommands;
import earth.terrarium.cadmus.common.util.ModUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.PistonEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

@Mod(value="cadmus")
public class CadmusForge {
    public CadmusForge() {
        Cadmus.init();
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(CadmusForge::onRegisterCommands);
        bus.addListener(CadmusForge::onServerStarted);
        bus.addListener(CadmusForge::onEnterSection);
        bus.addListener(CadmusForge::onRightClick);
        CadmusForge.registerChunkProtectionEvents(bus);
    }

    private static void registerChunkProtectionEvents(IEventBus bus) {
        bus.addListener(EventPriority.LOWEST, CadmusForge::onBlockPlace);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onBlockBreak);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onBlockInteract);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onEntityInteractSpecific);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onEntityInteract);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onAttackBlock);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onAttackEntity);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onFillBucket);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onExplode);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onFarmLandTrample);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onEntityMobGriefing);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onLivingDestroyBlock);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onItemPickup);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onEntityStruckByLightning);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onProjectileImpact);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onLivingAttack);
        bus.addListener(EventPriority.LOWEST, CadmusForge::onPistonPush);
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    private static void onServerStarted(ServerStartedEvent event) {
        Cadmus.serverStarted(event.getServer());
    }

    private static void onEnterSection(EntityEvent.EnteringSection event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Cadmus.enterChunkSection(player, event.getOldPos().m_123251_());
        }
    }

    private static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!ClaimApi.API.canBreakBlock(event.getPlayer().m_9236_(), event.getPos(), event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    private static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!ClaimApi.API.canPlaceBlock(player.m_9236_(), event.getPos(), (Player)player)) {
                event.setCanceled(true);
            }
        } else {
            ServerLevel level;
            entity = event.getLevel();
            if (entity instanceof ServerLevel && ClaimApi.API.isClaimed((Level)(level = (ServerLevel)entity), event.getPos())) {
                ClaimSettings defaultSettings;
                Pair<String, ClaimType> claim = ClaimHandler.getClaim(level, new ChunkPos(event.getPos()));
                if (claim == null) {
                    return;
                }
                ClaimSettings settings = CadmusDataHandler.getClaimSettings(level.m_7654_(), (String)claim.getFirst());
                if (!settings.canNonPlayersPlace(defaultSettings = CadmusDataHandler.getDefaultClaimSettings(level.m_7654_()))) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!ClaimApi.API.canInteractWithBlock(event.getEntity().m_9236_(), event.getPos(), InteractionType.USE, event.getEntity())) {
            event.setUseItem(Event.Result.ALLOW);
            event.setUseBlock(Event.Result.DENY);
        }
    }

    private static void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!ClaimApi.API.canInteractWithEntity(event.getEntity().m_9236_(), event.getTarget(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    private static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!ClaimApi.API.canInteractWithEntity(event.getEntity().m_9236_(), event.getTarget(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    private static void onAttackBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!ClaimApi.API.canBreakBlock(event.getEntity().m_9236_(), event.getPos(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    private static void onAttackEntity(AttackEntityEvent event) {
        if (!ClaimApi.API.canDamageEntity(event.getEntity().m_9236_(), event.getTarget(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    private static void onFillBucket(FillBucketEvent event) {
        HitResult target = event.getTarget();
        if (target != null && !ClaimApi.API.canBreakBlock(event.getLevel(), BlockPos.m_274446_((Position)target.m_82450_()), event.getEntity())) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    private static void onExplode(ExplosionEvent.Detonate event) {
        Player p;
        LivingEntity livingEntity = event.getExplosion().m_252906_();
        Player player = livingEntity instanceof Player ? (p = (Player)livingEntity) : null;
        event.getAffectedBlocks().removeIf(next -> ClaimApi.API.canExplodeBlock(event.getLevel(), new ChunkPos(next)) && (player == null || !ClaimApi.API.canExplodeBlock(event.getLevel(), (BlockPos)next, event.getExplosion(), player)));
        event.getAffectedEntities().removeIf(next -> ClaimApi.API.canExplodeBlock(event.getLevel(), next.m_146902_()) && (player == null || !ClaimApi.API.canDamageEntity(event.getLevel(), (Entity)next, player)));
    }

    private static void onFarmLandTrample(BlockEvent.FarmlandTrampleEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!ClaimApi.API.canBreakBlock(player.m_9236_(), event.getPos(), player)) {
                event.setCanceled(true);
            }
        } else if (!ClaimApi.API.canEntityGrief(event.getEntity().m_9236_(), event.getPos(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    private static void onEntityMobGriefing(EntityMobGriefingEvent event) {
        if (!ClaimApi.API.canEntityGrief(event.getEntity().m_9236_(), event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
    }

    private static void onLivingDestroyBlock(LivingDestroyBlockEvent event) {
        if (!ClaimApi.API.canEntityGrief(event.getEntity().m_9236_(), event.getPos(), (Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    private static void onItemPickup(EntityItemPickupEvent event) {
        if (!ClaimApi.API.canPickupItem(event.getItem().m_9236_(), event.getItem().m_20183_(), event.getItem(), (Entity)event.getEntity())) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    private static void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            Pair<String, ClaimType> claim = ClaimHandler.getClaim((ServerLevel)event.getEntity().m_9236_(), event.getEntity().m_146902_());
            if (claim != null && ModUtils.isAdmin((String)claim.getFirst())) {
                event.setCanceled(!AdminClaimHandler.getBooleanFlag(event.getEntity().m_9236_().m_7654_(), (String)claim.getFirst(), "lightning"));
            }
            if (event.getLightning().m_147158_() != null) {
                if (!ClaimApi.API.canDamageEntity(event.getEntity().m_9236_(), event.getEntity(), (Player)event.getLightning().m_147158_())) {
                    event.setCanceled(true);
                }
            } else if (!ClaimApi.API.canEntityGrief(event.getLightning().m_9236_(), (Entity)event.getLightning())) {
                event.setCanceled(true);
            }
        }
    }

    private static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getProjectile().m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!ClaimApi.API.canDamageEntity(event.getEntity().m_9236_(), event.getEntity(), player)) {
                event.setCanceled(true);
            }
        }
    }

    private static void onLivingAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!ClaimApi.API.canDamageEntity(event.getEntity().m_9236_(), (Entity)event.getEntity(), player)) {
                event.setCanceled(true);
            }
        }
    }

    private static void onPistonPush(PistonEvent.Pre event) {
    }

    private static void onRightClick(PlayerInteractEvent.RightClickItem event) {
        if (!event.getLevel().m_5776_()) {
            Pair<String, ClaimType> id = ClaimHandler.getClaim((ServerLevel)event.getLevel(), event.getEntity().m_146902_());
            if (id == null) {
                return;
            }
            if (!AdminClaimHandler.getBooleanFlag(event.getLevel().m_7654_(), (String)id.getFirst(), "use")) {
                event.setCanceled(true);
            }
        }
    }
}

