/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.teams;

import earth.terrarium.cadmus.api.teams.TeamProvider;
import earth.terrarium.cadmus.api.teams.TeamProviderApi;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TeamProviderApiImpl
implements TeamProviderApi {
    public final Map<ResourceLocation, TeamProvider> providers = new HashMap<ResourceLocation, TeamProvider>();
    @Nullable
    private ResourceLocation selected;

    @Override
    public void register(ResourceLocation id, TeamProvider provider) {
        if (this.providers.containsKey(id)) {
            throw new IllegalArgumentException("Provider already registered: " + id);
        }
        this.providers.put(id, provider);
    }

    @Override
    @Nullable
    public TeamProvider get(ResourceLocation id) {
        return this.providers.get(id);
    }

    @Override
    public TeamProvider getSelected() {
        return Objects.requireNonNull(this.providers.get(this.selected));
    }

    @Override
    @Nullable
    public ResourceLocation getSelectedId() {
        return this.selected;
    }

    @Override
    public void setSelected(@Nullable ResourceLocation id) {
        if (id != null && !this.providers.containsKey(id)) {
            throw new IllegalArgumentException("No provider registered for: " + id);
        }
        this.selected = id;
    }

    @Override
    public Collection<ResourceLocation> getIds() {
        return this.providers.keySet();
    }
}

