/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.network.messages;

import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.bytecodecs.defaults.MapCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.networking.base.CodecPacketHandler;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.cadmus.api.claims.ClaimApi;
import earth.terrarium.cadmus.common.claims.ClaimType;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public record ServerboundUpdateClaimedChunksPacket(Map<ChunkPos, ClaimType> addedChunks, Map<ChunkPos, ClaimType> removedChunks) implements Packet<ServerboundUpdateClaimedChunksPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("cadmus", "update_claimed_chunks");
    public static final Handler HANDLER = new Handler();

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<ServerboundUpdateClaimedChunksPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    extends CodecPacketHandler<ServerboundUpdateClaimedChunksPacket> {
        public Handler() {
            super(ObjectByteCodec.create((ObjectEntryByteCodec)new MapCodec(ExtraByteCodecs.CHUNK_POS, ClaimType.CODEC).fieldOf(ServerboundUpdateClaimedChunksPacket::addedChunks), (ObjectEntryByteCodec)new MapCodec(ExtraByteCodecs.CHUNK_POS, ClaimType.CODEC).fieldOf(ServerboundUpdateClaimedChunksPacket::removedChunks), ServerboundUpdateClaimedChunksPacket::new));
        }

        public PacketContext handle(ServerboundUpdateClaimedChunksPacket message) {
            return (player, level) -> {
                message.addedChunks.forEach((pos, type) -> {
                    if (ClaimApi.API.canClaim((ServerLevel)level, (ChunkPos)pos, type == ClaimType.CHUNK_LOADED, (ServerPlayer)player)) {
                        ClaimApi.API.claim((ServerLevel)level, (ChunkPos)pos, type == ClaimType.CHUNK_LOADED, (ServerPlayer)player);
                    }
                });
                message.removedChunks.forEach((pos, type) -> ClaimApi.API.unclaim((ServerLevel)level, (ChunkPos)pos, (ServerPlayer)player));
            };
        }
    }
}

