/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.compat.prometheus;

import com.teamresourceful.resourcefullib.common.utils.TriState;
import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfoUtils;
import earth.terrarium.cadmus.api.claims.maxclaims.MaxClaimProviderApi;
import earth.terrarium.cadmus.common.claims.CadmusDataHandler;
import earth.terrarium.cadmus.common.compat.prometheus.PrometheusMaxClaimProvider;
import earth.terrarium.cadmus.common.compat.prometheus.roles.CadmusOptions;
import earth.terrarium.cadmus.common.compat.prometheus.roles.client.CadmusOptionsDisplay;
import earth.terrarium.prometheus.api.events.ServerRolesUpdatedEvent;
import earth.terrarium.prometheus.api.permissions.PermissionApi;
import earth.terrarium.prometheus.api.roles.RoleApi;
import earth.terrarium.prometheus.api.roles.client.OptionDisplayApi;
import earth.terrarium.prometheus.api.roles.options.RoleOptionsApi;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PrometheusIntegration {
    public static final ResourceLocation PROMETHEUS_ID = new ResourceLocation("prometheus", "prometheus");

    public static boolean prometheusLoaded() {
        return ModInfoUtils.isModLoaded((String)"prometheus");
    }

    public static void registerClient() {
        PermissionApi api = PermissionApi.API;
        api.addAutoComplete("cadmus.block_breaking");
        api.addAutoComplete("cadmus.block_placing");
        api.addAutoComplete("cadmus.block_explosions");
        api.addAutoComplete("cadmus.block_interactions");
        api.addAutoComplete("cadmus.entity_interactions");
        api.addAutoComplete("cadmus.entity_damage");
        api.addAutoComplete("cadmus.personal.block_breaking");
        api.addAutoComplete("cadmus.personal.block_placing");
        api.addAutoComplete("cadmus.personal.block_explosions");
        api.addAutoComplete("cadmus.personal.block_interactions");
        api.addAutoComplete("cadmus.personal.entity_interactions");
        api.addAutoComplete("cadmus.personal.entity_damage");
        OptionDisplayApi.API.register(CadmusOptions.SERIALIZER.id(), CadmusOptionsDisplay::create);
    }

    public static void register() {
        RoleOptionsApi.API.register(CadmusOptions.SERIALIZER);
        MaxClaimProviderApi.API.register(PROMETHEUS_ID, new PrometheusMaxClaimProvider());
        MaxClaimProviderApi.API.setSelected(PROMETHEUS_ID);
        PermissionApi.API.addDefaultPermission("cadmus.personal.block_breaking", TriState.TRUE);
        PermissionApi.API.addDefaultPermission("cadmus.personal.block_placing", TriState.TRUE);
        PermissionApi.API.addDefaultPermission("cadmus.personal.block_explosions", TriState.TRUE);
        PermissionApi.API.addDefaultPermission("cadmus.personal.block_interactions", TriState.TRUE);
        PermissionApi.API.addDefaultPermission("cadmus.personal.entity_interactions", TriState.TRUE);
        PermissionApi.API.addDefaultPermission("cadmus.personal.entity_damage", TriState.TRUE);
        ServerRolesUpdatedEvent.register(event -> CadmusDataHandler.getMaxTeamClaims(event.server()).keySet().forEach(id -> MaxClaimProviderApi.API.getSelected().calculate((String)id, event.server())));
    }

    public static boolean hasPermission(Player player, String permission) {
        return PermissionApi.API.getPermission(player, permission).map(false);
    }

    public static int getMaxClaims(Player player) {
        return ((CadmusOptions)RoleApi.API.getNonNullOption(player, CadmusOptions.SERIALIZER)).maxClaims();
    }

    public static int getMaxClaims(Level level, UUID player) {
        return ((CadmusOptions)RoleApi.API.forceGetNonNullOption(level, player, CadmusOptions.SERIALIZER)).maxClaims();
    }

    public static int getMaxChunkLoaded(Player player) {
        return ((CadmusOptions)RoleApi.API.getNonNullOption(player, CadmusOptions.SERIALIZER)).maxChunkLoaded();
    }

    public static int getMaxChunkLoaded(Level level, UUID player) {
        return ((CadmusOptions)RoleApi.API.forceGetNonNullOption(level, player, CadmusOptions.SERIALIZER)).maxChunkLoaded();
    }
}

