/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.compat.journeymap;

import earth.terrarium.cadmus.client.ClientClaims;
import earth.terrarium.cadmus.common.compat.journeymap.ClaimedChunkDisplay;
import earth.terrarium.cadmus.common.compat.journeymap.ClaimedChunkOptions;
import java.util.EnumSet;
import java.util.Map;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.RegistryEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

@ClientPlugin
public class JourneyMapCompat
implements IClientPlugin {
    private static final String LISTENER_ID = "journeymap";
    private IClientAPI api;
    private ClaimedChunkOptions options;

    public void initialize(IClientAPI api) {
        this.api = api;
        this.api.subscribe(this.getModId(), EnumSet.of(ClientEvent.Type.DISPLAY_UPDATE, ClientEvent.Type.MAPPING_STARTED, ClientEvent.Type.MAPPING_STOPPED, ClientEvent.Type.REGISTRY));
    }

    public String getModId() {
        return "cadmus";
    }

    public void onEvent(ClientEvent event) {
        switch (event.type) {
            case DISPLAY_UPDATE: 
            case MAPPING_STARTED: {
                if (this.options != null && Boolean.TRUE.equals(this.options.showClaimedChunks.get())) {
                    ClientClaims.get((ResourceKey<Level>)event.dimension).addListener(LISTENER_ID, claims -> this.update((Map<ChunkPos, ClientClaims.Entry>)claims, (ResourceKey<Level>)event.dimension));
                    break;
                }
                ClientClaims.get((ResourceKey<Level>)event.dimension).removeListener(LISTENER_ID);
                this.clear();
                break;
            }
            case MAPPING_STOPPED: {
                ClientClaims.get((ResourceKey<Level>)event.dimension).removeListener(LISTENER_ID);
                this.clear();
                break;
            }
            case REGISTRY: {
                if (!(event instanceof RegistryEvent.OptionsRegistryEvent)) break;
                this.options = new ClaimedChunkOptions();
            }
        }
    }

    private void clear() {
        this.api.removeAll(this.getModId());
    }

    private void update(Map<ChunkPos, ClientClaims.Entry> claims, ResourceKey<Level> dimension) {
        this.clear();
        claims.forEach((chunkPos, entry) -> this.update((ChunkPos)chunkPos, (ClientClaims.Entry)entry, dimension));
    }

    private void update(ChunkPos pos, ClientClaims.Entry entry, ResourceKey<Level> dimension) {
        try {
            this.api.show((Displayable)ClaimedChunkDisplay.create(pos, entry, dimension));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

