/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.compat.journeymap;

import earth.terrarium.cadmus.client.ClientClaims;
import java.awt.geom.Point2D;
import journeymap.client.api.display.IOverlayListener;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.model.TextProperties;
import journeymap.client.api.util.PolygonHelper;
import journeymap.client.api.util.UIState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ClaimedChunkDisplay {
    public static PolygonOverlay create(ChunkPos pos, ClientClaims.Entry entry, ResourceKey<Level> dimension) {
        String displayId = "claim_" + pos.toString();
        int darkColor = FastColor.ARGB32.m_13660_((int)255, (int)((int)((float)(entry.color() >> 16 & 0xFF) * 0.8f)), (int)((int)((float)(entry.color() >> 8 & 0xFF) * 0.8f)), (int)((int)((float)(entry.color() & 0xFF) * 0.8f)));
        int lightColor = entry.color();
        ShapeProperties shapeProps = new ShapeProperties().setStrokeColor(darkColor).setStrokeWidth(2.0f).setStrokeOpacity(0.7f).setFillColor(lightColor).setFillOpacity(0.4f);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)pos.f_45578_, (int)70, (int)pos.f_45579_);
        PolygonOverlay overlay = new PolygonOverlay("cadmus", displayId, dimension, shapeProps, polygon);
        overlay.setTextProperties(new TextProperties().setColor(entry.color()));
        overlay.setOverlayListener((IOverlayListener)new Listener(overlay, entry));
        return overlay;
    }

    private record Listener(PolygonOverlay overlay, ClientClaims.Entry entry) implements IOverlayListener
    {
        public void onMouseMove(UIState mapState, Point2D.Double mousePosition, BlockPos blockPosition) {
            this.overlay.setTitle("Claimed by " + this.entry.name().getString());
        }

        public void onMouseOut(UIState mapState, Point2D.Double mousePosition, BlockPos blockPosition) {
            this.overlay.setTitle(null);
        }

        public void onActivate(UIState mapState) {
        }

        public void onDeactivate(UIState mapState) {
        }

        public boolean onMouseClick(UIState mapState, Point2D.Double mousePosition, BlockPos blockPosition, int button, boolean doubleClick) {
            return false;
        }

        public void onOverlayMenuPopup(UIState mapState, Point2D.Double mousePosition, BlockPos blockPosition, ModPopupMenu modPopupMenu) {
        }
    }
}

