/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.commands.claims.admin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.cadmus.api.claims.ClaimApi;
import earth.terrarium.cadmus.api.claims.admin.flags.ComponentFlag;
import earth.terrarium.cadmus.api.claims.admin.flags.Flag;
import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.commands.claims.ClaimException;
import earth.terrarium.cadmus.common.commands.claims.CommandHelper;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public class AdminClaimCommands {
    public static final SuggestionProvider<CommandSourceStack> ADMIN_CLAIM_SUGGESTION_PROVIDER = (context, builder) -> {
        Map<String, Map<String, Flag<?>>> claims = AdminClaimHandler.getAll(((CommandSourceStack)context.getSource()).m_81377_());
        return SharedSuggestionProvider.m_82981_(claims.keySet().stream(), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cadmus").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"adminclaims").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminClaimCommands.create(player, id));
            return 1;
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests(ADMIN_CLAIM_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminClaimCommands.remove(player, id));
            return 1;
        })))).then(Commands.m_82127_((String)"unclaim").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests(ADMIN_CLAIM_SUGGESTION_PROVIDER).then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ColumnPos pos = ColumnPosArgument.m_118992_((CommandContext)context, (String)"pos");
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminClaimCommands.unclaim(player, id, pos.m_143196_()));
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminClaimCommands.unclaim(player, id, player.m_146902_()));
            return 1;
        })))).then(Commands.m_82127_((String)"claim").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests(ADMIN_CLAIM_SUGGESTION_PROVIDER).then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).then(Commands.m_82129_((String)"chunkload", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ColumnPos pos = ColumnPosArgument.m_118992_((CommandContext)context, (String)"pos");
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            boolean chunkload = BoolArgumentType.getBool((CommandContext)context, (String)"chunkload");
            CommandHelper.runAction(() -> AdminClaimCommands.claim(player, id, pos.m_143196_(), chunkload));
            return 1;
        })))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminClaimCommands.claim(player, id, player.m_146902_(), false));
            return 1;
        })))));
    }

    public static void create(ServerPlayer player, String id) throws ClaimException {
        if (AdminClaimHandler.get(player.f_8924_, id) != null) {
            throw ClaimException.CLAIM_ALREADY_EXISTS;
        }
        AdminClaimHandler.create(player.f_8924_, id, new HashMap());
        AdminClaimHandler.setFlag(player.f_8924_, id, "display-name", new ComponentFlag((Component)Component.m_237113_((String)id)));
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.admin.create", (Object[])new Object[]{id}), false);
    }

    public static void remove(ServerPlayer player, String id) throws ClaimException {
        if (AdminClaimHandler.get(player.f_8924_, id) == null) {
            throw ClaimException.CLAIM_DOES_NOT_EXIST;
        }
        AdminClaimHandler.remove(player.f_8924_, id);
        ClaimHandler.clear(player.m_284548_(), "a:" + id);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.admin.remove", (Object[])new Object[]{id}), false);
    }

    public static void claim(ServerPlayer player, String id, ChunkPos pos, boolean chunkloaded) throws ClaimException {
        if (AdminClaimHandler.get(player.f_8924_, id) == null) {
            throw ClaimException.CLAIM_DOES_NOT_EXIST;
        }
        Pair<String, ClaimType> claimData = ClaimHandler.getClaim(player.m_284548_(), pos);
        if (claimData != null) {
            boolean isMember = TeamHelper.isMember((String)claimData.getFirst(), player.f_8924_, player.m_20148_());
            throw isMember ? ClaimException.ALREADY_CLAIMED_CHUNK : ClaimException.CHUNK_ALREADY_CLAIMED;
        }
        ClaimApi.API.claim(player.m_284548_(), pos, "a:" + id, chunkloaded);
        if (chunkloaded) {
            player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.claiming.chunk_loaded_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
        } else {
            player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.claiming.claimed_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
        }
    }

    public static void unclaim(ServerPlayer player, String id, ChunkPos pos) throws ClaimException {
        Pair<String, ClaimType> claimData = ClaimHandler.getClaim(player.m_284548_(), pos);
        if (claimData == null) {
            throw ClaimException.CHUNK_NOT_CLAIMED;
        }
        ClaimApi.API.unclaim(player.m_284548_(), pos, "a:" + id);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.unclaiming.unclaimed_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
    }
}

