/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.commands.claims;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.cadmus.api.claims.ClaimApi;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.commands.claims.ClaimException;
import earth.terrarium.cadmus.common.commands.claims.CommandHelper;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import earth.terrarium.cadmus.common.util.ModUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public class UnclaimCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"unclaim").then(Commands.m_82127_((String)"all").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> UnclaimCommand.clear(player));
            return 1;
        }))).then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ColumnPos pos = ColumnPosArgument.m_118992_((CommandContext)context, (String)"pos");
            CommandHelper.runAction(() -> UnclaimCommand.unclaim(player, pos.m_143196_()));
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> UnclaimCommand.unclaim(player, player.m_146902_()));
            return 1;
        }));
    }

    public static void unclaim(ServerPlayer player, ChunkPos pos) throws ClaimException {
        Pair<String, ClaimType> claimData = ClaimHandler.getClaim(player.m_284548_(), pos);
        if (claimData == null) {
            throw ClaimException.CHUNK_NOT_CLAIMED;
        }
        boolean isMember = TeamHelper.isMember((String)claimData.getFirst(), player.f_8924_, player.m_20148_());
        if (!isMember) {
            throw ClaimException.DONT_OWN_CHUNK;
        }
        if (ModUtils.isAdmin((String)claimData.getFirst())) {
            throw ClaimException.CANT_UNLCLAIM_ADMIN;
        }
        ClaimApi.API.unclaim(player.m_284548_(), pos, player);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.unclaiming.unclaimed_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
    }

    public static void clear(ServerPlayer player) {
        String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
        player.f_8924_.m_129785_().forEach(l -> ClaimHandler.clear(l, id));
        Component name = TeamHelper.getTeamName(id, player.f_8924_);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.clear", (Object[])new Object[]{name == null ? player.m_5446_().getString() : name.getString()}), false);
    }
}

