/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.commands.claims;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.cadmus.api.claims.ClaimApi;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.commands.claims.ClaimException;
import earth.terrarium.cadmus.common.commands.claims.CommandHelper;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public class ClaimCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"claim").then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).then(Commands.m_82129_((String)"chunkload", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ColumnPos pos = ColumnPosArgument.m_118992_((CommandContext)context, (String)"pos");
            boolean chunkload = BoolArgumentType.getBool((CommandContext)context, (String)"chunkload");
            CommandHelper.runAction(() -> ClaimCommand.claim(player, pos.m_143196_(), chunkload));
            return 1;
        })))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> ClaimCommand.claim(player, player.m_146902_(), false));
            return 1;
        }));
    }

    public static void claim(ServerPlayer player, ChunkPos pos, boolean chunkloaded) throws ClaimException {
        Pair<String, ClaimType> claimData = ClaimHandler.getClaim(player.m_284548_(), pos);
        if (claimData != null) {
            boolean isMember = TeamHelper.isMember((String)claimData.getFirst(), player.f_8924_, player.m_20148_());
            throw isMember ? ClaimException.ALREADY_CLAIMED_CHUNK : ClaimException.CHUNK_ALREADY_CLAIMED;
        }
        if (!ClaimApi.API.canClaim(player.m_284548_(), pos, chunkloaded, player)) {
            throw ClaimException.MAXED_OUT_CLAIMS;
        }
        ClaimApi.API.claim(player.m_284548_(), pos, chunkloaded, player);
        if (chunkloaded) {
            player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.claiming.chunk_loaded_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
        } else {
            player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.claiming.claimed_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
        }
    }
}

