/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.claims;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.cadmus.Cadmus;
import earth.terrarium.cadmus.api.claims.ClaimApi;
import earth.terrarium.cadmus.api.claims.InteractionType;
import earth.terrarium.cadmus.api.claims.maxclaims.MaxClaimProviderApi;
import earth.terrarium.cadmus.api.teams.TeamProviderApi;
import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import earth.terrarium.cadmus.common.claims.CadmusDataHandler;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimSettings;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.compat.prometheus.PrometheusIntegration;
import earth.terrarium.cadmus.common.util.ModEntityTags;
import earth.terrarium.cadmus.common.util.ModGameRules;
import earth.terrarium.cadmus.common.util.ModUtils;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.ToBooleanBiFunction;
import org.jetbrains.annotations.NotNull;

public class ClaimApiImpl
implements ClaimApi {
    @Override
    public boolean canClaim(ServerLevel level, ChunkPos pos, String id, boolean chunkLoad, UUID player) {
        Map<ChunkPos, ClaimType> currentClaims = ClaimHandler.getTeamClaims(level, id);
        if (currentClaims == null) {
            return true;
        }
        int maxClaims = MaxClaimProviderApi.API.getSelected().getMaxClaims(id, level, player);
        if (currentClaims.size() >= maxClaims) {
            return false;
        }
        if (chunkLoad) {
            int maxChunkLoaded;
            int currentChunkLoaded = currentClaims.values().stream().filter(claim -> claim == ClaimType.CHUNK_LOADED).toArray().length;
            return currentChunkLoaded < (maxChunkLoaded = MaxClaimProviderApi.API.getSelected().getMaxChunkLoaded(id, level, player));
        }
        return true;
    }

    @Override
    public void claim(ServerLevel level, ChunkPos pos, String id, boolean chunkLoad) {
        ClaimHandler.claim(level, id, pos, chunkLoad ? ClaimType.CHUNK_LOADED : ClaimType.CLAIMED);
        level.m_6907_().forEach(player -> ModUtils.displayTeamName(player, player.m_146902_()));
    }

    @Override
    public void unclaim(ServerLevel level, ChunkPos pos, String id) {
        ClaimHandler.unclaim(level, id, pos);
        level.m_6907_().forEach(player -> ModUtils.displayTeamName(player, player.m_146902_()));
    }

    @Override
    public boolean isClaimed(Level level, ChunkPos pos) {
        if (!level.m_5776_()) {
            return ClaimHandler.getClaim((ServerLevel)level, pos) != null;
        }
        return false;
    }

    @Override
    public boolean isChunkLoaded(Level level, ChunkPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Pair<String, ClaimType> claim = ClaimHandler.getClaim(serverLevel, pos);
            if (claim == null) {
                return false;
            }
            return claim.getSecond() == ClaimType.CHUNK_LOADED;
        }
        return false;
    }

    @Override
    public boolean canBreakBlock(Level level, BlockPos pos, UUID player) {
        return this.canAccess(level, pos, player, "cadmus.block_breaking", ModGameRules.RULE_DO_CLAIMED_BLOCK_BREAKING, true, (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> AdminClaimHandler.getBooleanFlag(server, id, "block-break")), (ToBooleanBiFunction<ClaimSettings, ClaimSettings>)((ToBooleanBiFunction)ClaimSettings::canBreak), (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> TeamProviderApi.API.getSelected().canBreakBlock((String)id, (MinecraftServer)server, pos, player)));
    }

    @Override
    public boolean canBreakBlock(Level level, BlockPos pos, @NotNull Player player) {
        return this.canBreakBlock(level, pos, player.m_20148_());
    }

    @Override
    public boolean canPlaceBlock(Level level, BlockPos pos, UUID player) {
        return this.canAccess(level, pos, player, "cadmus.block_placing", ModGameRules.RULE_DO_CLAIMED_BLOCK_PLACING, true, (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> AdminClaimHandler.getBooleanFlag(server, id, "block-place")), (ToBooleanBiFunction<ClaimSettings, ClaimSettings>)((ToBooleanBiFunction)ClaimSettings::canPlace), (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> TeamProviderApi.API.getSelected().canPlaceBlock((String)id, (MinecraftServer)server, pos, player)));
    }

    @Override
    public boolean canPlaceBlock(Level level, BlockPos pos, @NotNull Player player) {
        return this.canPlaceBlock(level, pos, player.m_20148_());
    }

    @Override
    public boolean canExplodeBlock(Level level, ChunkPos pos) {
        if (level.m_5776_()) {
            return false;
        }
        Pair<String, ClaimType> claim = ClaimHandler.getClaim((ServerLevel)level, pos);
        boolean isAdmin = claim != null && ModUtils.isAdmin((String)claim.getFirst());
        return claim != null && (!isAdmin || !AdminClaimHandler.getBooleanFlag(level.m_7654_(), (String)claim.getFirst(), "block-explosions"));
    }

    @Override
    public boolean canExplodeBlock(Level level, BlockPos pos, Explosion explosion, UUID player) {
        return this.canAccess(level, pos, player, "cadmus.block_explosions", ModGameRules.RULE_DO_CLAIMED_BLOCK_EXPLOSIONS, false, (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> AdminClaimHandler.getBooleanFlag(server, id, "block-explosions")), (ToBooleanBiFunction<ClaimSettings, ClaimSettings>)((ToBooleanBiFunction)ClaimSettings::canExplode), (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> TeamProviderApi.API.getSelected().canExplodeBlock((String)id, (MinecraftServer)server, pos, explosion, player)));
    }

    @Override
    public boolean canExplodeBlock(Level level, BlockPos pos, Explosion explosion, @NotNull Player player) {
        return this.canExplodeBlock(level, pos, explosion, player.m_20148_());
    }

    @Override
    public boolean canInteractWithBlock(Level level, BlockPos pos, InteractionType type, UUID player) {
        if (level.m_8055_(pos).m_204336_(Cadmus.ALLOWS_CLAIM_INTERACTIONS)) {
            return true;
        }
        return this.canAccess(level, pos, player, "cadmus.block_interactions", ModGameRules.RULE_DO_CLAIMED_BLOCK_INTERACTIONS, true, (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> {
            BlockState state = level.m_8055_(pos);
            if (state.m_204336_(Cadmus.DOOR_LIKE)) {
                return AdminClaimHandler.getBooleanFlag(server, id, "use-doors");
            }
            if (state.m_204336_(Cadmus.INTERACTABLE_STORAGE)) {
                return AdminClaimHandler.getBooleanFlag(server, id, "use-chests");
            }
            if (state.m_204336_(Cadmus.REDSTONE)) {
                return AdminClaimHandler.getBooleanFlag(server, id, "use-redstone");
            }
            return AdminClaimHandler.getBooleanFlag(server, id, "block-interactions");
        }), (ToBooleanBiFunction<ClaimSettings, ClaimSettings>)((ToBooleanBiFunction)ClaimSettings::canInteractWithBlocks), (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> TeamProviderApi.API.getSelected().canInteractWithBlock((String)id, (MinecraftServer)server, pos, type, player)));
    }

    @Override
    public boolean canInteractWithBlock(Level level, BlockPos pos, InteractionType type, @NotNull Player player) {
        return this.canInteractWithBlock(level, pos, type, player.m_20148_());
    }

    @Override
    public boolean canInteractWithEntity(Level level, Entity entity, UUID player) {
        if (entity.m_6095_().m_204039_(ModEntityTags.ALLOWS_CLAIM_INTERACTIONS_ENTITIES)) {
            return true;
        }
        return this.canAccess(level, entity.m_20183_(), player, "cadmus.entity_interactions", ModGameRules.RULE_DO_CLAIMED_ENTITY_INTERACTIONS, false, (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> AdminClaimHandler.getBooleanFlag(server, id, "entity-interactions")), (ToBooleanBiFunction<ClaimSettings, ClaimSettings>)((ToBooleanBiFunction)ClaimSettings::canInteractWithEntities), (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> TeamProviderApi.API.getSelected().canInteractWithEntity((String)id, (MinecraftServer)server, entity, player)));
    }

    @Override
    public boolean canInteractWithEntity(Level level, Entity entity, @NotNull Player player) {
        return this.canInteractWithEntity(level, entity, player.m_20148_());
    }

    @Override
    public boolean canDamageEntity(Level level, Entity entity, UUID player) {
        if (entity.m_6095_().m_204039_(ModEntityTags.ALLOWS_CLAIM_DAMAGE_ENTITIES)) {
            return true;
        }
        return this.canAccess(level, entity.m_20183_(), player, "cadmus.entity_damage", ModGameRules.RULE_CLAIMED_DAMAGE_ENTITIES, false, (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> {
            if (entity instanceof Player) {
                return AdminClaimHandler.getBooleanFlag(server, id, "pvp");
            }
            if (entity instanceof Enemy || entity.m_6095_().m_204039_(ModEntityTags.MONSTERS)) {
                return AdminClaimHandler.getBooleanFlag(server, id, "monster-damage");
            }
            if (entity instanceof Mob || entity.m_6095_().m_204039_(ModEntityTags.CREATURES)) {
                return AdminClaimHandler.getBooleanFlag(server, id, "creature-damage");
            }
            return AdminClaimHandler.getBooleanFlag(server, id, "entity-damage");
        }), (ToBooleanBiFunction<ClaimSettings, ClaimSettings>)((ToBooleanBiFunction)ClaimSettings::canDamageEntities), (ToBooleanBiFunction<String, MinecraftServer>)((ToBooleanBiFunction)(id, server) -> TeamProviderApi.API.getSelected().canDamageEntity((String)id, (MinecraftServer)server, entity, player)));
    }

    @Override
    public boolean canDamageEntity(Level level, Entity entity, @NotNull Player player) {
        return this.canDamageEntity(level, entity, player.m_20148_());
    }

    @Override
    public boolean canEntityGrief(Level level, @NotNull Entity entity) {
        return this.canEntityGrief(level, entity.m_20183_(), entity);
    }

    @Override
    public boolean canEntityGrief(Level level, BlockPos pos, @NotNull Entity entity) {
        if (entity.m_6095_().m_204039_(ModEntityTags.CAN_GRIEF_ENTITIES)) {
            return true;
        }
        if (!level.m_5776_()) {
            Pair<String, ClaimType> claim = ClaimHandler.getClaim((ServerLevel)level, new ChunkPos(pos));
            if (claim == null) {
                return true;
            }
            if (ModUtils.isAdmin((String)claim.getFirst())) {
                return AdminClaimHandler.getBooleanFlag((ServerLevel)level, new ChunkPos(pos), "mob-griefing");
            }
        }
        return ModGameRules.getOrCreateBooleanGameRule(level, ModGameRules.RULE_CLAIMED_MOB_GRIEFING);
    }

    @Override
    public boolean canPickupItem(Level level, BlockPos pos, ItemEntity item, @NotNull Entity picker) {
        if (item.m_32055_().m_204117_(Cadmus.ALLOWS_CLAIM_PICKUP)) {
            return true;
        }
        if (!level.m_5776_() && !AdminClaimHandler.getBooleanFlag((ServerLevel)level, new ChunkPos(pos), "item-pickup")) {
            return false;
        }
        if (ModGameRules.getOrCreateBooleanGameRule(level, ModGameRules.RULE_CAN_PICKUP_CLAIMED_ITEMS)) {
            return true;
        }
        if (Objects.equals(item.m_19749_(), picker)) {
            return true;
        }
        if (picker instanceof Player) {
            Player player = (Player)picker;
            return this.canInteractWithEntity(level, (Entity)item, player);
        }
        return this.canEntityGrief(level, picker);
    }

    private boolean canAccess(Level level, BlockPos pos, UUID player, String permission, GameRules.Key<GameRules.BooleanValue> rule, boolean checkBlock, ToBooleanBiFunction<String, MinecraftServer> checkFlags, ToBooleanBiFunction<ClaimSettings, ClaimSettings> checkSettings, ToBooleanBiFunction<String, MinecraftServer> checkTeamPermission) {
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.m_7654_();
        if (CadmusDataHandler.canBypass(server, player)) {
            return true;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        Pair<String, ClaimType> claim = ClaimHandler.getClaim(serverLevel, chunkPos);
        if (claim == null) {
            return true;
        }
        if (ModUtils.isAdmin((String)claim.getFirst()) && !checkFlags.applyAsBoolean((Object)((String)claim.getFirst()), (Object)server)) {
            return false;
        }
        if (checkBlock && CadmusDataHandler.isBlockAllowed(level.m_7654_(), (String)claim.getFirst(), level.m_8055_(pos).m_60734_())) {
            return true;
        }
        if (PrometheusIntegration.prometheusLoaded() && PrometheusIntegration.hasPermission(serverLevel.m_46003_(player), permission)) {
            return true;
        }
        if (!PrometheusIntegration.prometheusLoaded() && ModGameRules.getOrCreateBooleanGameRule(level, rule)) {
            return true;
        }
        ClaimSettings settings = CadmusDataHandler.getClaimSettings(server, (String)claim.getFirst());
        ClaimSettings defaultSettings = CadmusDataHandler.getDefaultClaimSettings(server);
        if (settings != null && checkSettings.applyAsBoolean((Object)settings, (Object)defaultSettings)) {
            return true;
        }
        if (!this.isClaimed(level, pos)) {
            return true;
        }
        return checkTeamPermission.applyAsBoolean((Object)((String)claim.getFirst()), (Object)server);
    }
}

