/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.claims;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import earth.terrarium.cadmus.common.claims.CadmusDataHandler;
import earth.terrarium.cadmus.common.constants.ConstantComponents;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import earth.terrarium.cadmus.common.util.ModUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ClaimAllowedBlocksCommand {
    private static final SimpleCommandExceptionType BLOCK_NOT_ADDED = new SimpleCommandExceptionType((Message)ConstantComponents.BLOCK_NOT_ADDED);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"claim").then(Commands.m_82127_((String)"settings").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"allowedBlocks").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"value", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)buildContext)).executes(context -> {
            BlockState block = BlockStateArgument.m_116123_((CommandContext)context, (String)"value").m_114669_();
            ClaimAllowedBlocksCommand.addBlock((CommandSourceStack)context.getSource(), block);
            return 1;
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"value", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)buildContext)).executes(context -> {
            BlockState block = BlockStateArgument.m_116123_((CommandContext)context, (String)"value").m_114669_();
            ClaimAllowedBlocksCommand.removeBlock((CommandSourceStack)context.getSource(), block);
            return 1;
        })))).then(Commands.m_82127_((String)"list").executes(context -> {
            ClaimAllowedBlocksCommand.listBlocks((CommandSourceStack)context.getSource());
            return 1;
        }))).executes(context -> {
            ClaimAllowedBlocksCommand.listBlocks((CommandSourceStack)context.getSource());
            return 1;
        }))));
    }

    private static void addBlock(CommandSourceStack source, BlockState block) throws CommandSyntaxException {
        CadmusDataHandler.addAllowedBlock(source.m_81377_(), TeamHelper.getTeamId((Player)source.m_81375_()), block.m_60734_());
        source.m_288197_(() -> ModUtils.translatableWithStyle("command.cadmus.setting.add_allowed_block", block.m_60734_().m_49954_()), false);
    }

    private static void removeBlock(CommandSourceStack source, BlockState block) throws CommandSyntaxException {
        String id = TeamHelper.getTeamId((Player)source.m_81375_());
        if (!CadmusDataHandler.isBlockAllowed(source.m_81377_(), id, block.m_60734_())) {
            throw BLOCK_NOT_ADDED.create();
        }
        CadmusDataHandler.removeAllowedBlock(source.m_81377_(), id, block.m_60734_());
        source.m_288197_(() -> ModUtils.translatableWithStyle("command.cadmus.setting.remove_allowed_block", block.m_60734_().m_49954_()), false);
    }

    private static void listBlocks(CommandSourceStack source) throws CommandSyntaxException {
        CadmusDataHandler.getAllowedBlocks(source.m_81377_(), TeamHelper.getTeamId((Player)source.m_81375_())).forEach(key -> {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(key);
            source.m_288197_(() -> ModUtils.translatableWithStyle("command.cadmus.setting.list_allowed_blocks", block == Blocks.f_50016_ ? key : block.m_49954_()), false);
        });
    }
}

