/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.action;

import com.almostreliable.lootjs.core.ILootAction;
import com.almostreliable.lootjs.core.ILootHandler;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.loot.results.Info;
import com.almostreliable.lootjs.loot.results.LootInfoCollector;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class CompositeLootAction
implements ILootAction {
    protected final Collection<ILootHandler> handlers;

    public CompositeLootAction(Collection<ILootHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public boolean applyLootHandler(LootContext context, List<ItemStack> loot) {
        LootInfoCollector collector = (LootInfoCollector)context.m_78953_(LootJSParamSets.RESULT_COLLECTOR);
        return this.run(context, loot, collector);
    }

    protected boolean run(LootContext context, List<ItemStack> loot, @Nullable LootInfoCollector collector) {
        for (ILootHandler handler : this.handlers) {
            Info info = LootInfoCollector.create(collector, handler);
            boolean result = handler.applyLootHandler(context, loot);
            LootInfoCollector.finalizeInfo(collector, info, result);
            if (result) continue;
            return false;
        }
        return true;
    }
}

