/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.mixin;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.brewery.client.BreweryClient;
import net.satisfy.brewery.core.effect.alcohol.AlcoholPlayer;
import net.satisfy.brewery.core.registry.MobEffectRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Redirect(method={"setupColor"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel$ClientLevelData;getClearColorScale()F"))
    @OnlyIn(value=Dist.CLIENT)
    private static float drunkColor(ClientLevel.ClientLevelData levelData) {
        MobEffectInstance effect;
        AlcoholPlayer alcoholPlayer;
        LocalPlayer player = BreweryClient.getPlayer();
        if (player instanceof AlcoholPlayer && (alcoholPlayer = (AlcoholPlayer)player).brewery$getAlcohol().isBlackout() && (effect = player.m_21124_((MobEffect)MobEffectRegistry.BLACKOUT.get())) != null && effect.m_19557_() <= 200) {
            if (effect.m_19557_() < 10) {
                return 1.0f - (float)effect.m_19557_() / 10.0f;
            }
            return 0.0f;
        }
        return levelData.m_205519_();
    }

    @Inject(method={"setupFog"}, at={@At(value="HEAD")}, cancellable=true)
    @OnlyIn(value=Dist.CLIENT)
    private static void drunkFog(Camera camera, FogRenderer.FogMode fogMode, float f, boolean bl, float g, CallbackInfo ci) {
        Entity entity = camera.m_90592_();
        if (entity instanceof LivingEntity) {
            int time;
            MobEffectInstance effect;
            AlcoholPlayer alcoholPlayer;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof AlcoholPlayer && (alcoholPlayer = (AlcoholPlayer)entity).brewery$getAlcohol().isBlackout() && (effect = livingEntity.m_21124_((MobEffect)MobEffectRegistry.BLACKOUT.get())) != null && (time = effect.m_19557_()) <= 200) {
                float distance = FogRendererMixin.brewery$blinkEffect(time);
                RenderSystem.setShaderFogStart((float)(fogMode == FogRenderer.FogMode.FOG_SKY ? 0.0f : distance * 0.75f));
                RenderSystem.setShaderFogEnd((float)distance);
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
                ci.cancel();
            }
        }
    }

    @Unique
    private static float brewery$blinkEffect(int time) {
        float scale = 70.0f;
        int distance = 5;
        float value = (float)distance * FogRendererMixin.brewery$power((float)time / (scale - 8.0f) - 3.0f, 2) * FogRendererMixin.brewery$power((float)time / scale - 1.0f, 10);
        return Mth.m_14036_((float)value, (float)0.0f, (float)64.0f);
    }

    @Unique
    private static float brewery$power(float base, int exponent) {
        float value = 1.0f;
        for (int i = 0; i < exponent; ++i) {
            value *= base;
        }
        return value;
    }
}

