/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.validation;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.common.spell.validation.BaseSpellValidationError;
import com.hollingsworth.arsnouveau.common.spell.validation.SpellPhraseValidator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class ActionAugmentationPolicyValidator
extends SpellPhraseValidator {
    @Override
    protected void validatePhrase(SpellPhraseValidator.SpellPhrase phrase, List<SpellValidationError> errors) {
        AbstractSpellPart action = phrase.getAction();
        if (action != null) {
            phrase.getAugmentPositionMap().forEach((augmentTag, augments) -> {
                int limit = action.getAugmentLimit((ResourceLocation)augmentTag);
                if (augments.size() > limit) {
                    for (int i = limit; i < augments.size(); ++i) {
                        errors.add(new ActionAugmentationPolicyValidationError(((SpellPhraseValidator.SpellPhrase.SpellPartPosition)augments.get((int)i)).position, (AbstractAugment)((SpellPhraseValidator.SpellPhrase.SpellPartPosition)augments.get((int)i)).spellPart, action, limit));
                    }
                }
            });
        }
    }

    private static class ActionAugmentationPolicyValidationError
    extends BaseSpellValidationError {
        public ActionAugmentationPolicyValidationError(int position, AbstractAugment augment, AbstractSpellPart action, int limit) {
            super(position, (AbstractSpellPart)augment, limit <= 0 ? "action_augmentation_policy.zero" : "action_augmentation_policy", action, augment);
        }
    }
}

