/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.setup.registry.DamageTypesRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class IceShardEntity
extends EnchantedFallingBlock {
    public LivingEntity shooter;

    public IceShardEntity(EntityType<? extends ColoredProjectile> p_31950_, Level p_31951_) {
        super(p_31950_, p_31951_);
    }

    public IceShardEntity(Level worldIn, double x, double y, double z, BlockState fallingBlockState, SpellResolver resolver) {
        super((EntityType<? extends ColoredProjectile>)((EntityType)ModEntities.ICE_SHARD.get()), worldIn, x, y, z, fallingBlockState, resolver);
    }

    @Override
    public void callOnBrokenAfterFall(Block p_149651_, BlockPos p_149652_) {
        super.callOnBrokenAfterFall(p_149651_, p_149652_);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            for (LivingEntity living : world.m_45976_(LivingEntity.class, new AABB(BlockPos.m_274446_((Position)this.f_19825_)).m_82400_(1.25))) {
                if (living == this.shooter) continue;
                living.m_6469_(DamageUtil.source((LevelAccessor)world, DamageTypesRegistry.COLD_SNAP, (Entity)(this.shooter == null ? ANFakePlayer.getPlayer(world) : this.shooter)), this.baseDamage);
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
            }
            world.m_8767_((ParticleOptions)ParticleTypes.f_123764_, this.f_19825_.f_82479_, this.f_19825_.f_82480_ + 0.5, this.f_19825_.f_82481_, 10, ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), 0.3);
            world.m_5594_(null, BlockPos.m_274446_((Position)this.f_19825_), SoundEvents.f_11984_, SoundSource.BLOCKS, 0.8f, 0.8f);
        }
    }

    @Override
    public void doPostHurtEffects(LivingEntity livingentity) {
        super.doPostHurtEffects(livingentity);
        livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
    }

    @Override
    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.ICE_SHARD.get();
    }
}

