/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.forge.client;

import java.util.function.Function;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.satisfy.beachparty.client.BeachPartyClient;
import net.satisfy.beachparty.client.model.FloatyBoatModel;
import net.satisfy.beachparty.core.entity.PalmBoatEntity;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.forge.client.integration.CuriosRubberRingAxolotlRenderer;
import net.satisfy.beachparty.forge.client.integration.CuriosRubberRingPelicanRenderer;
import net.satisfy.beachparty.forge.client.integration.CuriosRubberRingRenderer;
import net.satisfy.beachparty.forge.client.renderer.player.layers.RubberRingAxolotlLayer;
import net.satisfy.beachparty.forge.client.renderer.player.layers.RubberRingLayer;
import net.satisfy.beachparty.forge.client.renderer.player.layers.RubberRingPelicanLayer;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(modid="beachparty", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class BeachpartyClientForge {
    @SubscribeEvent
    public static void beforeClientSetup(RegisterEvent event) {
        BeachPartyClient.preInitClient();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            BeachPartyClient.initClient();
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_BLUE.get()), CuriosRubberRingRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_PINK.get()), CuriosRubberRingRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_STRIPPED.get()), CuriosRubberRingRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_PELICAN.get()), CuriosRubberRingPelicanRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.RUBBER_RING_AXOLOTL.get()), CuriosRubberRingAxolotlRenderer::new);
        });
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (PalmBoatEntity.Type type : PalmBoatEntity.Type.values()) {
            if (type == PalmBoatEntity.Type.FLOATY) {
                event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("beachparty", type.getModelLocation()), "main"), FloatyBoatModel::createBodyModel);
                event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("beachparty", type.getChestModelLocation()), "main"), FloatyBoatModel::createBodyModel);
                continue;
            }
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("beachparty", type.getModelLocation()), "main"), BoatModel::m_246613_);
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("beachparty", type.getChestModelLocation()), "main"), ChestBoatModel::m_247175_);
        }
    }

    @SubscribeEvent
    public static void registerLayersForRenderers(EntityRenderersEvent.AddLayers event) {
        BeachpartyClientForge.addLayerToPlayerSkin(event, "default", RubberRingLayer::new);
        BeachpartyClientForge.addLayerToPlayerSkin(event, "default", RubberRingPelicanLayer::new);
        BeachpartyClientForge.addLayerToPlayerSkin(event, "default", RubberRingAxolotlLayer::new);
        BeachpartyClientForge.addLayerToPlayerSkin(event, "slim", RubberRingAxolotlLayer::new);
        BeachpartyClientForge.addLayerToPlayerSkin(event, "slim", RubberRingLayer::new);
        BeachpartyClientForge.addLayerToPlayerSkin(event, "slim", RubberRingPelicanLayer::new);
    }

    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = event.getSkin(skinName);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }
}

